# HW4第一题说明

### 一、文件结构

* sim：存放modelsim工程文件
* src： 存放Verilog源代码
* README.md: 说明文档

### 二、源代码

* encoder_d.v :

```verilog
module encoder_d(D,x,y,V);
    input[3:0] D;
    output x,y,V;
    wire[3:0] D;
    reg x,y,V;
    always @(D) begin
       if (D[3]) begin x=1'b1;y=1'b1;V=1'b1;end
       else if (D[2]) begin x=1'b1;y=1'b0;V=1'b1;end
       else if (D[1]) begin x=1'b0;y=1'b1;V=1'b1;end
       else if (D[0]) begin x=1'b0;y=1'b0;V=1'b1;end
       else begin x=1'b0;y=1'b0;V=1'b0;end
    end
endmodule
```

* encoder_tb.v：

```verilog
`timescale 1ns/1ps
`include "encoder_d.v"

module encoder_tb(D,x,y,V);
    output[3:0] D;
    input x,y,V;
    reg[3:0] D;
    wire x,y,V;
    encoder_d enc(D,x,y,V);
    initial begin
        #10 D=4'b0000;
        #10 D=4'b0001;
        #10 D=4'b0010;
        #10 D=4'b0100;
        #10 D=4'b0101;
        #10 D=4'b0110;
        #10 D=4'b0111;
        #10 D=4'b1000;
        #10 D=4'b1001;
        #10 D=4'b1010;
        #10 D=4'b1011;
        #10 D=4'b1100;
        #10 D=4'b1101;
        #10 D=4'b1110;
        #10 D=4'b1111;
        #10 $finish;
    end
endmodule
```

### 三、仿真结果

![仿真截图](./%E4%BB%BF%E7%9C%9F%E6%88%AA%E5%9B%BE.png)

### 四、其他

代码已保存在个人gitlab主页，如文件打开有问题可查看gitlab：

[http://xlab.zju.edu.cn/git/zzy/sd_hw4](http://xlab.zju.edu.cn/git/zzy/sd_hw4)

