// pages/music/music.js
import { musictable } from '../../json/musiclib.js'
const innerAudioContext = wx.createInnerAudioContext()
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    albumList: [
      '全部专辑',
      '腐草为萤',
      '蚍蜉渡海',
      '琉璃',
      '银临EP(2012)',
      '风花雪月EP',
      '离地十公分EP',
      '单曲',
      '其他歌手&OST'
    ],
    typeList: [
      '全部类型',
      'SOLO',
      '双人原唱',
      '多人原创',
      '翻唱',
      '纯音乐',
      '为他人创作'
    ],
    platformList: [
      '全部平台',
      '腾讯系',
      '网易',
      '跨平台'
    ],
    languageList: [
      '全部语种',
      '国语',
      '英语'
    ],
    albumIsSelected: [
      true,false,false,false,false,false,false,false,false
    ],
    typeIsSelected: [
      true,false,false,false,false,false,false
    ],
    platformIsSelected: [
      true,false,false
    ],
    languageIsSelected: [
      true,false,false
    ],
    res: {},
    displayList: musictable.data,
    isInfo: -1,
    playList: musictable.data,
    curIndex: 0,
    orderIndex: 0,
    orderList: [
      '../../assets/cycle.png',
      '../../assets/only.png',
      '../../assets/rand.png'
    ],
    isList: false,
    albumText: [
      '全部专辑',
      '腐草为萤',
      '蚍蜉渡海',
      '琉璃',
      '银临（2012）EP',
      '风花雪月EP',
      '离地十公分EP',
      '单曲专辑',
      '其他歌手&OST专辑'
    ],
    typeText: [
      '全部类型',
      'SOLO',
      '双人原唱',
      '多人原唱',
      '翻唱（非制作）',
      '纯音乐',
      '为他人创作'
    ],
    onPlay: false,
  },
  playMusic: function() {
    if (this.data.playList[this.data.curIndex].platform == '跨平台' || this.data.playList[this.data.curIndex].platform == '网易') {
      innerAudioContext.autoplay = false;
      innerAudioContext.src = "http://music.163.com/song/media/outer/url?id="+this.data.playList[this.data.curIndex].url+".mp3";
      innerAudioContext.pause();
      innerAudioContext.play();
      this.setData({
        onPlay: true,
      })
    }
    else {
      wx.request({
        url:"https://m.kugou.com/app/i/getSongInfo.php?cmd=playInfo&hash="+this.data.playList[this.data.curIndex].url,
        method:"GET",
        success: res => {
          console.log("请求成功",res.data);
          innerAudioContext.autoplay = false
          innerAudioContext.src = res.data.url
          innerAudioContext.play();
          this.setData({
            onPlay: true,
          })
        },
        fail: err => {
          console.log("请求失败",err);
        }
      })
    }
  },
  pauseMusic: function() {
    innerAudioContext.pause();
    console.log("暂停");
    this.setData({
      onPlay: false,
    })
  },
  closePopup: function() {
    this.setData({
      isList: false,
      isInfo: -1,
    })
  },
  goOnMusic: function() {
    innerAudioContext.play();
    console.log("播放");
    this.setData({
      onPlay: true,
    })
  },
  selectList: function(albumIndex, typeIndex, platformIndex, languageIndex) {
    var a = [];
    var b = musictable.data;
    if (albumIndex != 0) {
      for (var i=0;i<b.length;i++) {
        if (b[i].album == this.data.albumText[albumIndex]) {
          a.push(b[i]);
        }
      }
    }
    else {
      a = b;
    }
    var c = [];
    if (typeIndex != 0) {
      for (var i=0;i<a.length;i++) {
        if (a[i].SOLO == this.data.typeText[typeIndex]) {
          c.push(a[i]);
        }
      }
    }
    else {
      c = a;
    }
    var d = [];
    if (platformIndex != 0) {
      for (var i=0;i<c.length;i++) {
        if (c[i].platform == this.data.platformList[platformIndex]) {
          d.push(c[i]);
        }
      }
    }
    else {
      d = c;
    }
    var e = [];
    if (languageIndex != 0) {
      for (var i=0;i<d.length;i++) {
        if (d[i].language == this.data.languageList[languageIndex]) {
          e.push(d[i]);
        }
      }
    }
    else {
      e = d;
    }
    this.setData({
      displayList: e,
    })
  },
  changeAlbumSelect: function(e) {
    var a = [];
    for (var i=0;i<9;i++) {
      a.push(false);
    }
    a[e.currentTarget.dataset.info] = true;
    this.setData({
      albumIsSelected: a
    });
    this.selectList(this.data.albumIsSelected.indexOf(true), this.data.typeIsSelected.indexOf(true), this.data.platformIsSelected.indexOf(true), this.data.languageIsSelected.indexOf(true));
  },
  changeTypeSelect: function(e) {
    var a = [];
    for (var i=0;i<7;i++) {
      a.push(false);
    }
    a[e.currentTarget.dataset.info] = true;
    this.setData({
      typeIsSelected: a
    });
    this.selectList(this.data.albumIsSelected.indexOf(true), this.data.typeIsSelected.indexOf(true), this.data.platformIsSelected.indexOf(true), this.data.languageIsSelected.indexOf(true));
  },
  changePlatformSelect: function(e) {
    var a = [];
    for (var i=0;i<4;i++) {
      a.push(false);
    }
    a[e.currentTarget.dataset.info] = true;
    this.setData({
      platformIsSelected: a
    });
    this.selectList(this.data.albumIsSelected.indexOf(true), this.data.typeIsSelected.indexOf(true), this.data.platformIsSelected.indexOf(true), this.data.languageIsSelected.indexOf(true));
  },
  changeLanguageSelect: function(e) {
    var a = [];
    for (var i=0;i<7;i++) {
      a.push(false);
    }
    a[e.currentTarget.dataset.info] = true;
    this.setData({
      languageIsSelected: a
    });
    this.selectList(this.data.albumIsSelected.indexOf(true), this.data.typeIsSelected.indexOf(true), this.data.platformIsSelected.indexOf(true), this.data.languageIsSelected.indexOf(true));
  },
  moreInfo: function(e) {
    this.setData({
      isInfo: e.currentTarget.dataset.info,
    })
  },
  closeInfo: function() {
    this.setData({
      isInfo: -1,
    })
  },
  changeOrder: function() {
    this.setData({
      orderIndex: (this.data.orderIndex + 1) % 3
    })
  },
  playThis: function(e) {
    this.setData({
      curIndex: e.currentTarget.dataset.info,
    })
    this.playMusic();
  },
  deleteThis: function(e) {
    var a = [];
    for (var i=0;i<this.data.playList.length;i++) {
      if (i != e.currentTarget.dataset.info) {
        a.push(this.data.playList[i]);
      }
    }
    this.setData({
      playList: a,
    })
    this.pauseMusic();
    this.playMusic();
  },
  deleteAll: function() {
    this.setData({
      playList: [],
      curIndex: 0,
    })
  },
  list: function() {
    this.setData({
      isList: !this.data.isList,
    })
  },
  addNext: function(e) {
    var a = [];
    var delIndex = this.data.playList.indexOf(this.data.displayList[e.currentTarget.dataset.info]);
    if (this.data.playList.length==0) {
      a.push(this.data.displayList[e.currentTarget.dataset.info]);
      this.setData({
        playList: a,
      });
      wx.showToast({
        title: '添加成功',
        icon: 'success',
        duration: 2000,      // 2秒
      });
      return;
    }
    for (var i=0;i<this.data.playList.length;i++) {
      if (i == delIndex && this.data.curIndex != delIndex) continue;
      if (i != this.data.curIndex) {
        a.push(this.data.playList[i]);
      }
      else {
        a.push(this.data.playList[i]);
        if (this.data.playList[i].name != this.data.displayList[e.currentTarget.dataset.info].name) {
          a.push(this.data.displayList[e.currentTarget.dataset.info]);
        }
      }
    }
    this.setData({
      playList: a,
    })
    wx.showToast({
      title: '添加成功',
      icon: 'success',
      duration: 2000,      // 2秒
    });
  },
  addEnd: function(e) {
    var a = [];
    var delIndex = this.data.playList.indexOf(this.data.displayList[e.currentTarget.dataset.info]);
    for (var i=0;i<this.data.playList.length;i++) {
      if (i == delIndex) continue;
      a.push(this.data.playList[i]);
    }
    a.push(this.data.displayList[e.currentTarget.dataset.info]);
    this.setData({
      playList: a,
    })
    wx.showToast({
      title: '添加成功',
      icon: 'success',
      duration: 2000,      // 2秒
    });
  },
  joinPlayThis: function(e) {
    var a = [];
    var delIndex = this.data.playList.indexOf(this.data.displayList[e.currentTarget.dataset.info]);
    if (this.data.playList.length==0) {
      a.push(this.data.displayList[e.currentTarget.dataset.info]);
      this.setData({
        playList: a,
      });
      this.playMusic();
      wx.showToast({
        title: '添加成功',
        icon: 'success',
        duration: 2000,      // 2秒
      });
      return;
    }
    for (var i=0;i<this.data.playList.length;i++) {
      if (i == delIndex && this.data.curIndex != delIndex) continue;
      if (i != this.data.curIndex) {
        a.push(this.data.playList[i]);
      }
      else {
        if (this.data.playList[i].name != this.data.displayList[e.currentTarget.dataset.info].name) {
          a.push(this.data.displayList[e.currentTarget.dataset.info]);
        }
        a.push(this.data.playList[i]);
      }
    }
    this.setData({
      playList: a,
    })
    this.playMusic();
    wx.showToast({
      title: '添加成功',
      icon: 'success',
      duration: 2000,      // 2秒
    });

  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad(options) {
      // wx.request({
      //   url:"https://m.kugou.com/app/i/getSongInfo.php?cmd=playInfo&hash=4715997d039f890d94d3de76af81c726",
      //   method:"GET",
      //   success: res => {
      //     console.log("请求成功",res.data);
      //     innerAudioContext.autoplay = false
      //     innerAudioContext.src = res.data.url
      //     innerAudioContext.onPlay(() => {
      //     console.log('开始播放')
      //     })
      //     innerAudioContext.onError((res) => {
      //       console.log(res.errMsg)
      //       console.log(res.errCode)
      //     })
        
      //     innerAudioContext.onPause(
      //       () =>{
      //         console.log('停止播放')
      //       }
      //     )
      //   },
      //   fail: err => {
      //     console.log("请求失败",err);
      //   }
      // })
      innerAudioContext.autoplay = false;
      innerAudioContext.src = "http://music.163.com/song/media/outer/url?id="+this.data.playList[this.data.curIndex].url+".mp3";
      innerAudioContext.onEnded(()=>{
        if (this.data.orderIndex == 0) {
          if (this.data.curIndex < this.data.playList.length) {
            this.setData({
              curIndex: this.data.curIndex+1,
            });
            this.playMusic();
          }
          else {
            this.setData({
              curIndex: 0,
            });
            this.playMusic();
          }
        }
        else if (this.data.orderIndex == 2) {
          this.setData({
            curIndex: randomNum(0, this.data.playList.length),
          })
        }
      });
  },
  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady() {
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage() {

  }
})


function randomNum(minNum,maxNum){ 
  switch(arguments.length){ 
      case 1: 
          return parseInt(Math.random()*minNum+1,10); 
      break; 
      case 2: 
          return parseInt(Math.random()*(maxNum-minNum+1)+minNum,10); 
      break; 
          default: 
              return 0; 
          break; 
  } 
}