// index.js
// 获取应用实例
const app = getApp()

const innerAudioContext = wx.createInnerAudioContext()

Page({
  data: {
    motto: '这是首页',
    userInfo: {},
    hasUserInfo: false,
    canIUse: wx.canIUse('button.open-type.getUserInfo'),
    canIUseGetUserProfile: false,
    canIUseOpenData: wx.canIUse('open-data.type.userAvatarUrl') && wx.canIUse('open-data.type.userNickName'),
    aid: '607824247',
    timestamp: getTimestamp(),
  },
  goBilibili: function () {
    const aid = '607824247'
    const timestamp = new Date().getTime()
    const path = `pages/video/video?__preload_=${timestamp * 10 + 3}&__key_=${timestamp * 10 + 4}&avid=${aid}`
    wx.navigateToMiniProgram({
      appId: 'wx7564fd5313d24844',
      path,
      success: res => {
        console.log('跳转成功')
      }
    })
  },

  // 事件处理函数
  bindViewTap() {
    wx.navigateTo({
      url: '../logs/logs'
    })
  },
  playAudio: function () {
    innerAudioContext.play();
  },
  pauseAudio: function () {
    innerAudioContext.pause();
  },
  onLoad() {
    if (wx.getUserProfile) {
      this.setData({
        canIUseGetUserProfile: true
      });
    }
    innerAudioContext.autoplay = false
    innerAudioContext.src = 'http://music.163.com/song/media/outer/url?id=1483504366.mp3'
    innerAudioContext.onPlay(() => {
      console.log('开始播放')
    })
    innerAudioContext.onError((res) => {
      console.log(res.errMsg)
      console.log(res.errCode)
    })

    innerAudioContext.onPause(
      () => {
        console.log('停止播放')
      }
    )
  },
  onShow() {

  },
  getUserProfile(e) {
    // 推荐使用wx.getUserProfile获取用户信息，开发者每次通过该接口获取用户个人信息均需用户确认，开发者妥善保管用户快速填写的头像昵称，避免重复弹窗
    wx.getUserProfile({
      desc: '展示用户信息', // 声明获取用户个人信息后的用途，后续会展示在弹窗中，请谨慎填写
      success: (res) => {
        console.log(res)
        this.setData({
          userInfo: res.userInfo,
          hasUserInfo: true
        })
      }
    })
  },
  getUserInfo(e) {
    // 不推荐使用getUserInfo获取用户信息，预计自2021年4月13日起，getUserInfo将不再弹出弹窗，并直接返回匿名的用户个人信息
    console.log(e)
    this.setData({
      userInfo: e.detail.userInfo,
      hasUserInfo: true
    })
  }
})
function getTimestamp() {
  var timeStamp = 0;
  timeStamp = new Date().getTime();
  console.log(timeStamp);
  return timeStamp;
}

const list =
  [
    {
      "name": "帕金森患者如何进行居家康复训练",
      "publishTime": "2023年3月11日",
      "cover": "https://p2.music.126.net/LBnYDAUED2mD1veBvBnC8g==/5859297464524710.jpg?param=130y130",
      "url": "http://znjqr.zj.moocollege.com/datacenter/news/detail?id=4764"
    },
    {
      "name": "帕金森患者如何进行居家康复训练",
      "publishTime": "2023年3月11日",
      "cover": "https://i0.hdslb.com/bfs/live/cc8522721479a23a03967adb48ef2fbf1c7cac31.jpg@412w_232h_1c.avif",
      "url": "https://www.overleaf.com/project/646e2bde71cd2e2659eb7ab84"
    }
  ]