/**
 * @file i2c
 * @brief zzy
 * 
 * @version 0.1
 * @date 2023-05-13
 * 
 * @copyright Copyright (c) 2023
 * 
 */
#ifndef __I2C_H_
#define __I2C_H_

#include "main.h"
#include <stdlib.h>


class IIC
{
private:
    GPIO_TypeDef *SCL_GPIO_PORT;
    uint16_t SCL_PIN;
    GPIO_TypeDef *SDA_GPIO_PORT;
    uint16_t SDA_PIN;
public:
    IIC(GPIO_TypeDef *scl_gpio_port, uint16_t scl_pin, GPIO_TypeDef *sda_gpio_port, uint16_t sda_pin);
    void WriteSDA(GPIO_PinState PinState);
    void WriteSCL(GPIO_PinState PinState);
    GPIO_PinState ReadSDA();
    GPIO_PinState ReadSCL();
    void Delay();
    void Start();
    void End();
    void Send_ACK(uint8_t ack);
    uint8_t Get_ACK();
    uint8_t SendByte(uint8_t dat);
    uint8_t ReadByte(uint8_t ack);
    uint8_t WriteLen(uint8_t addr, uint8_t reg, uint8_t len, uint8_t *buf);
    uint8_t ReadLen(uint8_t addr, uint8_t reg, uint8_t len, uint8_t *buf);
};

#endif