#!/usr/bin/env python3
import rospy
from std_msgs.msg import String
import socket
 
#2.初始化 ROS 节点:命名(唯一)
rospy.init_node("Remote_Controller")
#3.实例化 发布者 对象
pub = rospy.Publisher("Manager", String, queue_size=1)
#4.组织被发布的数据，并编写逻辑发布数据
rate = rospy.Rate(2)

server = socket.socket()
server.bind(('localhost', 6789))
server.listen(5)
 
exit = ''
msg = String()
while True:
    con, addr = server.accept()
    print('connect_addr: ', addr)
    while con:
        data = con.recv(1024).decode('utf-8')
        if data[0:2] == 'ab' and data[-2:] == 'cd':
            while not rospy.is_shutdown():
                msg.data = data[2:-2]
                pub.publish(msg)
                rate.sleep()
 
            if data == 'break':
                con.close()
                exit = 'break'
                break
    if exit == 'break':
        break
server.close()