#!/usr/bin/env python
from cgitb import reset
import time
import math
import sys
sys.path.append("/home/yyf/ros03/src/hotwheelspkg/scripts")#导入模块，搜索当前目录、已安装内置模块、第三方模块
from tracemalloc import start
from uservo import serial, UartServoManager
from FileManager import *
import rospy
from std_msgs.msg import String
#from calculate import calc_angleup, calc_angledown, calc_posup, calc_posdown

# UART
SERVO_PORT_NAME =  '/dev/ttyAMA0'		# 舵机串口号
SERVO_BAUDRATE = 115200			# 舵机的波特率
# 初始化串口
uart = serial.Serial(port=SERVO_PORT_NAME, baudrate=SERVO_BAUDRATE,
				parity=serial.PARITY_NONE, stopbits=1,
				bytesize=8,timeout=0)
uservo = UartServoManager(uart)
filefolder = dict()

class ServoManager:
    # 自定义舵机名称
    neck = 1            #脖子
    left_hand = 2       #左上肢
    left_arm = 3
    left_shoulder = 4   
    right_hand = 5      #右上肢
    right_arm = 6 
    right_shoulder = 7
    left_legdown = 8   #左下肢
    left_legup = 9    
    left_foot = 10     
    right_legdown = 11  #右下肢
    right_legup = 12
    right_foot = 13
    left_hip = 14     #臀部
    right_hip = 15
    
    neck = [neck]
    left_up = [left_hand, left_arm, left_shoulder]
    right_up = [right_hand, right_arm, right_shoulder] 
    left_down = [left_legdown, left_legup, left_foot ] 
    right_down = [right_legdown, right_legup, right_foot]
    hip = [left_hip, right_hip]
    ALL = [neck, left_up, right_up, left_down, right_down, hip]
    servo_num = 15
    base = []
   
    sign = [ +1,                 #neck 
            +1, -1, +1,        #left_up
            -1, -1, -1,         #right_up
            -1, +1, -1,         #left_down
            +1, +1, +1,         #right_down
            +1, +1]             #hip
   
    #舵机初始化，扫描舵机个数，获得舵机基准状态参数
    def __init__(self):
        print("> Manager: 开始初始化舵机...")
        self.ServoScan()#扫描所有舵机
        self.LoadBase()#读取base配置文件
    #展示初始状态动作
    def Init(self):
        print("> Manager: 读取舵机RESET配置文件")
        self.LoadServo('reset', 'Init')
    #保存初始状态动作
    def SetInit(self):
        print("> Manager: 保存初始RESET状态")
        self.SaveServo('reset', 'Init')
   
    #文件操作
    #显示指定的记录文件内容
    def ShowFolder(self):
        print('> FILE: 文件管理器列表: ')
        for folder in filefolder:
            print(f'    {folder}/{filefolder[folder].FILE_NAME + filefolder[folder].FILE_EXTENSION}')
    
    # 获得单个舵机相对角度
    def GetSingleAngle(self, servo_index):
        return self.sign[servo_index - 1] * (int(uservo.query_servo_angle(servo_index)) - self.base[servo_index - 1])
 
    # 获得单个舵机绝对角度
    def GetSingleAngleAbs(self, servo_index):
        return int(uservo.query_servo_angle(servo_index))
    
    # 获得所有舵机相对角度
    def GetAllAngle(self):
        data = []
        for servo_index in range(1, self.servo_num + 1):
            data.append(str(self.GetSingleAngle(servo_index)))
            
        return ','.join(data) + '\n'
   
    # 获得所有舵机绝对角度
    def GetAllAngleAbs(self):
        data = []
        for servo_index in range(1, self.servo_num + 1):
            data.append(str(self.GetSingleAngleAbs(servo_index)))
        return ','.join(data) + '\n'
        print(data)
  
    #保存动作，保存相对角度
    def SaveServo(self, filename, subpath='Defalut', index=0):
        data = self.GetAllAngle()
        filefolder[subpath] = FileManager(filename, subpath)
        filefolder[subpath].WriteFile(data, index)
   
    #保存基准状态
    def SaveBase(self):
        data = self.GetAllAngleAbs()
        FileManager('base', 'Init', '.abs').WriteFile(data, 0)
  
    #记录时间流
    def SaveServoFlow(self, filename, recordtime, subpath='TimeFlow'):
        print('> Manager: 时间流开始记录')
        self.DampAll()
        start_time = time.time()
        lines = []
        while time.time() - start_time < recordtime:
            line = []
            # uservo.query_all_srv_angle()
            for servo_id in uservo.servos:
                line.append(str(self.GetSingleAngle(servo_id)))
            lines.append(line)
            print("\r> Manager: The program has processed {:2}%".format(100 * (time.time() - start_time) / recordtime), end="")
        print('')
        liness = []
        for line in lines:
            liness.append(','.join(line) + '\n')
        filefolder[subpath] = FileManager(filename, subpath, extension='.flow')
        filefolder[subpath].WriteFileAll(liness)	
        print('> Maneger: 底层时间流记录完成， 用时', time.time() - start_time)
  
    #读取基准状态#
    def LoadBase(self):
        print("> Manager: 读取舵机BASE配置文件")
        filefolder['Init'] = GetFileObject('base', 'Init', '.abs')
        line = filefolder['Init'].lines[0]
        data = line[:-1].split(',')
        for servo_index in range(1, self.servo_num + 1):
            self.base.append(int(data[servo_index - 1]))
   
    #展示动作
    def LoadServo(self, filename='defalut', subpath='Defalut', index=0, delay=0.0):
        filefolder[subpath] = GetFileObject(filename, subpath)
        line = filefolder[subpath].lines[index]
        data = line[:-1].split(',')
        for servo_index in range(1, self.servo_num + 1):
            self.SettingSingleAngle(servo_index, int(data[servo_index - 1]), delay)
            time.sleep(0.1) #THE LAST STEP
   
    #底层时间流运行
    def LoadServoFlow(self, filename='defalut', subpath='TimeFlow'):
        print('> Manager: 底层时间流开始运行')
        start_time = time.time()
        filefolder[subpath + '/' + filename] = FileManager(filename, subpath, ".flow")
        lines = filefolder[subpath + '/' + filename].lines
        for line in lines:
            step_start_time = time.time()
            data = line[:-1].split(',')
            i = 0 
            for servo_id in uservo.servos:
                self.SettingSingleAngle(servo_id, int(data[i]))
                i += 1
            # time.sleep(5/136 - (time.time() - step_start_time))
        print('> Manager: 底层时间流运行完成, 用时', time.time() - start_time)

   #发送控制单个舵机角度请求#
    def SettingSingleAngle(self, servo_index, angle, t=0.0):
        t = int(1000 * t)
        angle = self.base[servo_index - 1] + self.sign[servo_index - 1] * angle
        uservo.set_servo_angle(servo_index, angle, interval=t)
   
    #显示所有舵机相对角度#
    def ShowServoState(self, t=0):
        showname = ['脖子', '左上肢', '右上肢', '左下肢', '右下肢', '臀部']
        print("> Manager: 相对角度")
        for i in range(6):
                print(f'    {showname[i]}: {[(self.GetSingleAngle(servo_index)) for servo_index in self.ALL[i]]}')
  
    #显示所有舵机绝对角度#
    def ShowServoAbsState(self, t=0):
        showname = ['脖子', '左上肢', '右上肢', '左下肢', '右下肢', '臀部']
        print("> Manager: 绝对角度")
        for i in range(6):
                print(f'    {showname[i]}: {[(self.GetSingleAngleAbs(servo_index)) for servo_index in self.ALL[i]]}')
   
    #扫描舵机，所有的舵机必须首先扫描才可以接受其他指令的控制#
    def ServoScan(self):
        global uservo
        print("> Uservo: 开始进行舵机扫描")
        uservo.scan_servo()
        servo_list = list(uservo.servos.keys())
        print(f"> Uservo: 舵机扫描结束,共{len(servo_list)}个舵机", ", 舵机列表: {}".format(servo_list))
   
    #使舵机转变为低阻尼模式，在这种状态下即可手动掰动对应的舵机#
    def Damp(self, servo_index):#单个
        uservo.set_damping(servo_index)
    def DampAll(self):
        print(uservo.servos)
        for servo_index in range(1, self.servo_num -1)                                                                                                                        :
            uservo.set_damping(servo_index)
            time.sleep(0.1)


    #显示电量
    def GetVol(self):
        vol_list = [uservo.query_voltage(servo_index) for servo_index in uservo.servos]
        print('> Manager: Vol: ', sum(vol_list) / len(vol_list))
  
    #写入动作，与ws/rs命令类似，但是一个文件只保存一个动作
    #因此可以通过文件名直接索引动作，不用通过文件名+序号的繁琐方式。
    #默认子目录为Action
    def WriteAction(self, act_name):
        self.ShowServoState(0)
        self.SaveServo(act_name, 'Action')
        self.ShowServoState(0)

    #读取动作
    def ReadAction(self, act_name):
        self.ShowServoState(0)
        self.LoadServo(act_name, 'Action')
        self.ShowServoState(0)
def response(msg):
    cmd = msg.data
    exec(cmd)

#main程序
if __name__ == "__main__":

    manager = ServoManager()

    msg = String()

    rospy.init_node("UservoSDK")

    sub = rospy.Subscriber("Manager", String, response)

    rate = rospy.Rate(1000)
    
    rospy.spin()
    rate.sleep()
