import math, sympy
from numpy import angle
# 计算单位: cm
L1 = 8.0000             # 大腿长
L2 = 15.321             # 小腿长
X0 = 15                 # 初始腿的末端到舵机根的距离
# 定义初始位置满足的关系
# L1*cos(base1)+L2*cos(base2)=x0
# L1*sin(base1)+L2*sin(base2)=0
base1 = 1.3427          #arccos((L1**2+X0**2-L2**2)/(2*X0*L1))
base2 = -0.5336         #base1代入方程反解

def calc_turn(input_angle):
    # input_angle 实际转过的角度， 返回舵机转的角度
    input_angle = input_angle / 180 * 3.1415926
    temp = math.asin(8 / 11 * math.sin(input_angle)) + input_angle
    res = int(-temp / 3.1415926 * 180)
    # print("SdjakdjakljdklaJdljadk: ", res)
    return res
    # return 2 * math.atan(11*math.sin(input_angle)/(11*math.cos(input_angle)+8))  / 3.1415926 * 180

#小腿153.21, 大腿80
def calc_pos(angle1, angle2):
    rad1 = angle1 / 180 * 3.1415926
    rad2 = angle2 / 180 * 3.1415926
    x = L1 * math.cos(rad1 + base1) + L2 * math.cos(rad1 + rad2 + base2)
    y = L1 * math.sin(rad1 + base1) + L2 * math.sin(rad1 + rad2 + base2)
    return x, y

#temp1 = (L2*L2-L1*L1 - (x**2+y**2)) / 2*L1
#temp2 = (L2*L2-L1*L1 + (x**2+y**2)) / 2*L2
def calc_angle(x, y):    
    # x*sin(r1)+y*cos(r1)=sqrt(x**2+y**2)sin(r1+atan(y/x))
    # 两个常数分别为L2**2-L1**2, 2*L1
    square = x**2 + y**2
    temp1 = (square - (L2 * L2 - L1 * L1)) / (2 * L1)   
    # 辅助角
    at = math.pi/2 if x == 0 else math.atan(y/x)
    rad1 = math.acos(temp1 / math.sqrt(square)) + at - base1
    angle1 = int(rad1 / 3.1415926 * 180)
    temp2 = (square + (L2 * L2 - L1 * L1)) / (2 * L2)
    rad2 = -math.acos(temp2 / math.sqrt(square)) + at - rad1 - base2
    angle2 = int(rad2 / 3.1415926 * 180)

    flag = 1
    # if(angle2 > 90):
    #     angle2 = angle2 - 180 
    return flag, angle1, angle2

if __name__ == "__main__":
    # pass
    print(calc_turn(-17))
    # print(int(calc_turn(20) / 3.1415926 * 180))
    # print(int(calc_turn(30) / 3.1415926 * 180))
    # print(int(calc_turn(40) / 3.1415926 * 180))
    # print(int(calc_turn(50) / 3.1415926 * 180))
    # x, y = calc_pos(28, -27)
    # print(x, y)
    # _, angle1, angle2 = calc_angle(x, y)
    # print(angle1, angle2)
    # print(calc_pos(-46, 17))
    # print(calc_pos(angle1, angle2))
    # print(calc_pos(0, 0))
    # print(calc_pos(-29, -14))
