#!/usr/bin/env python
import time
import sys
import rospy
from std_msgs.msg import String
from sensor_msgs.msg import Joy

avoid_flag = False
online_flag = False
mode_flag = False # 足式形态->滚轮形态
walk_delay = 0.3
roll_delay = 1.0
def joy_callback(data):
    global avoid_flag, online_flag, mode_flag
    global walk_delay, roll_delay
    # print(data)
    # axes向左为正，向上为正
    # L2,R2默认为1.0, 按下为-1.0
    # axes6，7由两组按钮上下左右控制
    # print("axes0(LX): ", data.axes[0])
    # print("axes1(LY): ", data.axes[1])
    # print("axes2(L2): ", data.axes[2])
    # print("axes3(RX): ", data.axes[3])
    # print("axes4(RY): ", data.axes[4])
    # print("axes5(R2): ", data.axes[5])
    # print("axes6(十字左右): ", data.axes[6])
    # print("axes7(十字上下): ", data.axes[7])
    LX, LY, L2, RX, RY, R2, left_right, up_down = data.axes
    left = left_right > 0
    right = left_right < 0
    up = up_down > 0
    down = up_down < 0
    L2 = L2 < 0
    R2 = R2 < 0
    # print("buttons0(A): ", data.buttons[0])
    # print("buttons1(B): ", data.buttons[1])
    # print("buttons2(X): ", data.buttons[2])
    # print("buttons3(Y): ", data.buttons[3])
    # print("buttons4(L1): ", data.buttons[4])
    # print("buttons5(R1): ", data.buttons[5])
    # print("buttons6(select): ", data.buttons[6])
    # print("buttons7(start): ", data.buttons[7])
    # print("buttons8(mode): ", data.buttons[8])
    # print("buttons9(L3): ", data.buttons[9])
    # print("buttons10(R3): ", data.buttons[10])
    A, B, X, Y, L1, R1, select, start, mode, L3, R3 = data.buttons
    #flag
    msg = String()
    if(start == 1):
        if not mode_flag:
            msg.data = "manager.Init()"
            print(msg.data)
            pub.publish(msg)
        else:
            msg.data = "manager.ReadAction('wheel')"
            print(msg.data)
            pub.publish(msg)
    elif(select == 1):
        msg.data = "manager.GetVol()"
        print(msg.data)
        pub.publish(msg)
    elif(L3 == 1):
        msg.data = "manager.ServoScan()"
        print(msg.data)
        pub.publish(msg)
    elif(mode == 1):
        mode_state = "TransForm()" if not mode_flag else "TransFormBack()"
        mode_flag = not mode_flag
        msg.data = "manager." + mode_state
        print(msg.data)
        pub.publish(msg)
    elif(up and not mode_flag):
        msg.data = "manager.WalkOnce(delay=" + str(walk_delay) + ")"
        print(msg.data)
        pub.publish(msg)
    elif(left and not mode_flag):
        msg.data = "manager.TurnLeft()"
        print(msg.data)
        pub.publish(msg)
    elif(right and not mode_flag):
        msg.data = "manager.TurnRight()"
        print(msg.data)
        pub.publish(msg)
    elif(down and not mode_flag):
        msg.data = "manager.WalkBackOnce(delay=" + str(walk_delay) + ")"
        print(msg.data)
        pub.publish(msg)
    elif(A and not mode_flag):
        avoid_state = "AvoidOn()" if not avoid_flag else "AvoidOff()"
        avoid_flag = not avoid_flag
        msg.data = "manager." + avoid_state
        print(msg.data)
        pub.publish(msg)
    elif(X and not mode_flag):
        online_state = "OnlineOn()" if not online_flag else "OnlineOff()"
        online_flag = not online_flag
        msg.data = "manager." + online_state
        print(msg.data)
        pub.publish(msg)
    elif(Y and mode_flag):
        msg.data = "manager.Roll(delay=" + str(roll_delay) + ")"
        print(msg.data)
        pub.publish(msg)
    elif(B):
        msg.data = "manager.DampAll()"
        print(msg.data)
        pub.publish(msg)
    elif(L1 and not mode_flag):
        walk_delay = walk_delay + 0.1 if walk_delay <= 0.3 else 0.4
        msg.data = "manager.set_walk_delay(" + str(walk_delay) + ")"
        print(msg.data)
        pub.publish(msg)
    elif(L2 and not mode_flag):
        walk_delay = walk_delay - 0.1 if walk_delay >= 0.2 else 0.1
        msg.data = "manager.set_walk_delay(" + str(walk_delay) + ")"
        pub.publish(msg)
        print(msg.data)
    elif(R1 and mode_flag):
        roll_delay = roll_delay + 0.05 if roll_delay <= 1.95 else 2.0
        print("new roll_delay: ", roll_delay)
    elif(R2 and mode_flag):
        roll_delay = roll_delay - 0.05 if roll_delay >= 0.05 else 0.0
        print("new roll_delay: ", roll_delay)
    elif(R3):
        mode_flag = not mode_flag
        print("new mode_flag: ", mode_flag)

if __name__ == "__main__":
    #2.初始化 ROS 节点:命名(唯一)
    rospy.init_node("JoyController")
    #3.实例化 发布者 对象
    pub = rospy.Publisher("Manager", String, queue_size=1)
    #4.组织被发布的数据，.并编写逻辑发布数据
    sub = rospy.Subscriber("joy", Joy, joy_callback)
    #5.循环发布数据
    rospy.spin()