import cv2
import rospy
from sensor_msgs.msg import CameraInfo, Image
from std_msgs.msg import String
from cv_bridge import CvBridge
import numpy as np
import math


def find_color(image, color='blue'):
    '''
    寻找色块
    '''
    color_dist = {
        'red': {'Lower': np.array([0, 60, 60]), 'Upper': np.array([6, 255, 255])},
        'blue': {'Lower': np.array([97, 224, 70]), 'Upper': np.array([124, 255, 255])},
        'green': {'Lower': np.array([35, 43, 35]), 'Upper': np.array([90, 255, 255])},
    }
    gs_frame = cv2.GaussianBlur(image, (5, 5), 0)                     # 高斯模糊
    hsv = cv2.cvtColor(gs_frame, cv2.COLOR_BGR2HSV)                 # 转化成HSV图像
    erode_hsv = cv2.erode(hsv, None, iterations=2)                   # 腐蚀 粗的变细
    inRange_hsv = cv2.inRange(erode_hsv, color_dist[color]['Lower'], color_dist[color]['Upper'])    #识别颜色
    cnts = cv2.findContours(inRange_hsv.copy(), cv2.RETR_EXTERNAL, cv2.CHAIN_APPROX_SIMPLE)[-2]     #寻找轮廓
    try:
        c = max(cnts, key=cv2.contourArea)                              #寻找最大色块
    except:
        return 0
    rect = cv2.minAreaRect(c)                                       #找最小的包裹色块的矩形
    box = cv2.boxPoints(rect)                                       #box的点
    sumx = 0.0
    sumy = 0.0
    for pi in box:
        sumx += pi[0]
        sumy += pi[1]
    center = (int(sumx / 4), int(sumy / 4))
    sita = math.atan(math.tan(34.5 / 180 * 3.1415926) * (center[0] - 320) / 320) / 3.1415926 * 180
    # print("center, sita = ", center, sita)
    # cv2.drawContours(image, [np.int0(box)], -1, (0, 255, 255), 2)
    # cv2.circle(image, center, 7, (0, 0, 0), -1)
    return sita

def image_process(msg):
    image = CvBridge().imgmsg_to_cv2(msg, "bgr8")
    sita = find_color(image)
    # cv2.imshow('image', new_image)
    # cv2.waitKey(1)
    return sita
    # cv2.imwrite('1.jpg', image)

# 目标所在未知在图片中的角度
# def get_angle():
#     rospy.spinOnce()
#     return .sita

def depth_process(msg):
    image = CvBridge().imgmsg_to_cv2(msg, '16UC1')
    image_arr = np.array(image)
    # print(image_arr.shape[0])
    divide_p = [image_arr.shape[1] // 4, image_arr.shape[1] // 2, image_arr.shape[1] * 3 // 4]
    center_part = image_arr[int(image_arr.shape[0] / 2):, divide_p[0]:divide_p[2]]
    left_part = image_arr[int(image_arr.shape[0] / 2):, 0:divide_p[1]]
    right_part = image_arr[int(image_arr.shape[0] / 2):, divide_p[1]:image_arr.shape[1]]
    center_part_mean = center_part.mean()
    left_part_mean = left_part.mean()
    right_part_mean = right_part.mean()
    return center_part_mean, left_part_mean, right_part_mean

def depth_callback(msg):
    print(depth_process(msg))
    image = CvBridge().imgmsg_to_cv2(msg, '16UC1')
    image -= image.min()
    image = image / (image.max() - image.min())
    image *= 255
    # image_arr = np.array(image) 
    # print(image_arr)
    cv2.imwrite('2.jpg', image)
    # np.savetxt( "a.csv", image_arr, delimiter=",")


if __name__ == "__main__":
    rospy.init_node("camera")

    # sub = rospy.Subscriber("/camera/color/image_raw", Image, image_process)
    depth = rospy.Subscriber("/camera/aligned_depth_to_color/image_raw", Image, depth_callback)

    rate = rospy.Rate(1000)

    rospy.spin()
    rate.sleep()