#!/usr/bin/env python
import math
import sys
sys.path.append("/home/yyf/ros03/src/hotwheelspkg/scripts")
from manager import ServoManager as SM
from FileManager import *
from calculate import calc_pos

def MergeFlow(base_flow_name: str, adding_flow_name: str, generate_flow_name: str, index_group: list):
    '''
    将base_flow_name和adding_flow_name合并到generate_flow_name中
    '''
    generation = FileManager(generate_flow_name, "TimeFlow", ".flow")
    base = FileManager(base_flow_name, "TimeFlow", ".flow")
    adding = FileManager(adding_flow_name, "TimeFlow", ".flow")
    base_lines = base.lines
    adding_lines = adding.lines
    len1 = len(base_lines)
    len2 = len(adding_lines)

    if(len1 < len2):    # 原始Flow更短，则延拓最后一帧
        final_frame = base_lines[-1]
        for i in range(len2 - len1):
            base_lines.append(final_frame)
    new_lines = []
    for line_index in range(len2):
        data_new = base_lines[line_index][:-1].split(',')
        data_adding = adding_lines[line_index][:-1].split(',')
        for adding_servo_index in index_group:
            data_new[adding_servo_index] = data_adding[adding_servo_index]
        new_line = ','.join(data_new) + '\n'
        new_lines.append(new_line)
    generation.WriteFileAll(new_lines)
    print(f'> FILE: 生成的Flow文件为: /TimeFlow/{generate_flow_name}.flow')

# base覆盖target
def TransLeg(source_flow_name: str, base_flow_name: str, new_name: str, base_servo_group: list, target_servo_group:list):
    '''
    从source中抽取出一组servo的数据, 并将其覆盖到target中, 保存为新的flow文件
    '''
    base = FileManager(base_flow_name, "TimeFlow", ".flow")
    source = FileManager(source_flow_name, "TimeFlow", ".flow")
    new = FileManager(new_name, "TimeFlow", ".flow")
    new_lines = source.lines.copy()
    base_lines = base.lines.copy()
    for line_index in range(len(new_lines)):
        data_new = new_lines[line_index][:-1].split(',')
        data_base = base_lines[line_index][:-1].split(',')
        for i in range(3):
            data_base[target_servo_group[i] - 1] = data_new[base_servo_group[i] - 1]
        new_lines[line_index] = ','.join(data_base) + '\n'
    new.WriteFileAll(new_lines)
    print(f'> FILE: 生成的Flow文件为: /TimeFlow/{new_name}.flow')


def MergeSomeFlow(base_flow_name: str, adding_flow_name: str, generate_flow_name: str, index_group: list, base_start_id: int, copy_length: int):
    '''
    将base_flow_name和adding_flow_name中的一段合并到generate_flow_name中
    '''
    generation = FileManager(generate_flow_name, "TimeFlow", ".flow")
    base = FileManager(base_flow_name, "TimeFlow", ".flow")
    adding = FileManager(adding_flow_name, "TimeFlow", ".flow")
    base_lines = base.lines
    adding_lines = adding.lines
    len1 = len(base_lines)
    len2 = len(adding_lines)

    if(len1 < len2):    # 原始Flow更短，则延拓最后一帧
        final_frame = base_lines[-1]
        for i in range(len2 - len1):
            base_lines.append(final_frame)
    new_lines = []
    for line_index in range(copy_length):
        data_new = base_lines[base_start_id + line_index][:-1].split(',')
        data_adding = adding_lines[line_index][:-1].split(',')
        for adding_servo_index in index_group:
            data_new[adding_servo_index] = data_adding[adding_servo_index]
        new_line = ','.join(data_new) + '\n'
        new_lines.append(new_line)
    generation.WriteFileAll(new_lines)
    print(f'> FILE: 生成的Flow文件为: /TimeFlow/{generate_flow_name}.flow')

def SetFlowStep(base_flow_name: str, new_flow_name: str, step_id: int, new_step: list, alpha = 0.7):
    '''
    为了实现重设局部, 将改变点附近的帧全部随之改变, 变化率以alpha倍率衰减, 保存为新的flow文件
    '''
    base = FileManager(base_flow_name, "TimeFlow", ".flow")
    new = FileManager(new_flow_name, "TimeFlow", ".flow")
    base_lines = base.lines
    new_lines = []
    base_data = base_lines[step_id].split(',')
    delta = [new_step[i] - base_data[i] for i in range(len(new_step))]
    for line_index in range(len(base_lines)):
        data_new = base_lines[line_index][:-1].split(',')
        for i in range(len(new_step)):
            data_new[i] = str(int(base_data[i]) + int(delta[i] * (alpha**abs(line_index - step_id))))
        new_line = ','.join(data_new) + '\n'
        new_lines.append(new_line)
    new.WriteFileAll(new_lines)
    print(f'> FILE: 生成的Flow文件为: /TimeFlow/{new_flow_name}.flow')

def ExpandRoll(file_name, times=5):
    base = FileManager("roll", "Step")
    new = FileManager(file_name, "Step")
    base_lines = base.lines
    new_lines = []
    zero_pos = base_lines[0]
    new_lines.append(zero_pos)
    for i in range(times):
        for line in base_lines[1:]:
            new_lines.append(line)
            new_lines.append(zero_pos)
    new.WriteFileAll(new_lines)
    print(f'> FILE: 完成')

if __name__ == "__main__":
    # MergeFlow(sys.argv[1], sys.argv[2], "turn0", SM.RIGHT_BACK)
    # TransLeg(source_flow_name='turndone', base_flow_name='turndone', new_name='turndone',\
        # base_servo_group=SM.LEFT_FRONT, target_servo_group=SM.RIGHT_BACK)
    # TransLeg('turn0', SM.LEFT_BACK, SM.LEFT_FRONT, 'turn0')
    # TransLeg('turn0', SM.LEFT_BACK, SM.RIGHT_BACK, 'turn0')
    # TransLeg('turn0', SM.LEFT_LEG, SM.RIGHT_LEG, 'turn0')
    ExpandRoll('roll3')