#!/usr/bin/env python
from asyncio import futures
from math import sin, cos
import sys
sys.path.append("/home/yyf/ros03/src/hotwheelspkg/scripts")

class FileManager:
    FILE_PATH = '/home/yyf/ros03/recording/'
    FILE_SUB_PATH = ''
    FILE_NAME = 'default'
    FILE_EXTENSION = '.save'
    
    lines = []
    num = 0

    def __init__(self, filename=FILE_NAME, subpath=FILE_SUB_PATH, extension=FILE_EXTENSION):
        self.FILE_NAME = filename
        self.FILE_SUB_PATH = subpath
        self.FILE_EXTENSION = extension
        print(f'> File: 文件系统初始化: {self.FILE_PATH + self.FILE_SUB_PATH + "/" + self.FILE_NAME + self.FILE_EXTENSION}')
        self.LoadFile()
    
    def Show(self):
        print("> FILE: INFO:")
        print(f"    File Path: {self.FILE_PATH + '/' + self.FILE_SUB_PATH}")
        print(f"    File Name: {self.FILE_NAME + self.FILE_EXTENSION}")
        print(f"    File Content: (Line Num: {self.num})")
        for line in self.lines:
            print("      ", line)

    def LoadFile(self):
        file = self.FILE_PATH + self.FILE_SUB_PATH + '/' + self.FILE_NAME + self.FILE_EXTENSION
        try:
            with open(file, 'r') as f:
                self.lines = f.readlines()
                self.num = len(self.lines)
                # print('> File: 打开文件成功')
        except:
            with open(file, 'w') as f:
                print("> File: 创建新文件")

    def WriteFile(self, data, index=0):
        while index >= len(self.lines):
            self.lines.append('\n')
        self.lines[index] = data

        file = self.FILE_PATH + self.FILE_SUB_PATH + '/' + self.FILE_NAME + self.FILE_EXTENSION
        with open(file, 'w') as f:
            f.writelines(self.lines)
            # print('> File: 写入文件成功')
        
    def ChangeFile(self, filename):
        self.FILE_NAME = filename
        self.LoadFile()
    
    def WriteFileAll(self, lines):
        file = self.FILE_PATH + self.FILE_SUB_PATH + '/' + self.FILE_NAME + self.FILE_EXTENSION
        with open(file, 'w') as f:
            f.writelines(lines)
            # print('> File: 写入时间流文件成功')

FilePool = {}

def GetFileObject(filename='default', subpath='', extension='.save'):
    full_name = subpath + "/" + filename + extension
    if full_name not in FilePool:
        FilePool[full_name] = FileManager(filename, subpath, extension)
    else:
        FilePool[full_name].LoadFile()
    return FilePool[full_name]