# 
# Synthesis run script generated by Vivado
# 

proc create_report { reportName command } {
  set status "."
  append status $reportName ".fail"
  if { [file exists $status] } {
    eval file delete [glob $status]
  }
  send_msg_id runtcl-4 info "Executing : $command"
  set retval [eval catch { $command } msg]
  if { $retval != 0 } {
    set fp [open $status w]
    close $fp
    send_msg_id runtcl-5 warning "$msg"
  }
}
set_msg_config -id {Synth 8-256} -limit 10000
set_msg_config -id {Synth 8-638} -limit 10000
create_project -in_memory -part xc7a200tfbg484-1

set_param project.singleFileAddWarning.threshold 0
set_param project.compositeFile.enableAutoGeneration 0
set_param synth.vivado.isSynthRun true
set_property webtalk.parent_dir E:/3210105816/digitalsystemlabs/lab_5/vivado/abs_dif.cache/wt [current_project]
set_property parent.project_path E:/3210105816/digitalsystemlabs/lab_5/vivado/abs_dif.xpr [current_project]
set_property default_lib xil_defaultlib [current_project]
set_property target_language Verilog [current_project]
set_property ip_output_repo e:/3210105816/digitalsystemlabs/lab_5/vivado/abs_dif.cache/ip [current_project]
set_property ip_cache_permissions {read write} [current_project]
read_verilog -library xil_defaultlib {
  E:/3210105816/digitalsystemlabs/lab_5/src/comp.v
  E:/3210105816/digitalsystemlabs/lab_5/src/full_adder.v
  E:/3210105816/digitalsystemlabs/lab_5/src/mux_2to1.v
  E:/3210105816/digitalsystemlabs/lab_5/src/abs_dif.v
}
# Mark all dcp files as not used in implementation to prevent them from being
# stitched into the results of this synthesis run. Any black boxes in the
# design are intentionally left as such for best results. Dcp files will be
# stitched into the design at a later time, either when this synthesis run is
# opened, or when it is stitched into a dependent implementation run.
foreach dcp [get_files -quiet -all -filter file_type=="Design\ Checkpoint"] {
  set_property used_in_implementation false $dcp
}
read_xdc E:/3210105816/digitalsystemlabs/lab_5/src/abs_div.xdc
set_property used_in_implementation false [get_files E:/3210105816/digitalsystemlabs/lab_5/src/abs_div.xdc]


synth_design -top abs_dif -part xc7a200tfbg484-1


# disable binary constraint mode for synth run checkpoints
set_param constraints.enableBinaryConstraints false
write_checkpoint -force -noxdef abs_dif.dcp
create_report "synth_1_synth_report_utilization_0" "report_utilization -file abs_dif_utilization_synth.rpt -pb abs_dif_utilization_synth.pb"
