module song_reader(clk, reset, play, song, note_done, song_done, note, duration, new_note);

input clk, reset, note_done;
input[1:0] song;
output song_done, new_note;
output[5:0] note, duration;

wire[5:0] q;
wire co;

// 地址计数器
conter#(.n(32), .counter_bits(5)) scn(.clk(clk), .r(reset), .en(note_done), .q(q), .co(co));
// 控制器
song_reader_ctrl src(.clk(clk), .reset(reset), .note_done(note_done), .play(play), .new_note(new_note));
// song_rom
song_rom sr(.clk(clk), .dout({note, duration}), .addr({song, q}));
// 结束判断
over ov(.clk(clk), .r(co), .din(duration), .dout(song_done));
endmodule