module over(clk, r, din, dout);
input clk, r;                 
input [5:0] din;             
output reg dout;              
parameter PAUSE = 0, PLAY = 1; 
reg state, nextstate;     

always @(posedge clk) begin
    if(r) begin 
            dout = 1; 
            state =  PAUSE; 
        end
    else state = nextstate;
end

always @(posedge clk) begin 
    dout = 0;
    case (state) 
        PAUSE: begin 
            if(din) nextstate = PLAY;   
            else nextstate = PAUSE; 
            end 
        PLAY: begin 
            if(din == 0) begin 
                dout = 1; 
                nextstate = PAUSE; 
                end      
            else nextstate = PLAY;              
            end     
        default: nextstate = PAUSE;
    endcase
end
endmodule