import { NextResponse } from 'next/server';

export async function POST() {
  try {
    const response = NextResponse.json({ message: '登出成功' });
    
    response.cookies.set('auth_token', '', {
      httpOnly: true,
      secure: process.env.NODE_ENV === 'production',
      sameSite: 'strict',
      maxAge: -1, 
      path: '/',
    });

    return response;
    
  } catch (error) {
    console.error('登出失败:', error);
    return NextResponse.json(
      { message: '服务器内部错误' },
      { status: 500 }
    );
  }
}

