import { NextRequest, NextResponse } from 'next/server';
import { getUserFromRequest } from '@/lib/auth';
import prisma from '@/lib/prisma';

export async function POST(request: NextRequest) {
    try {
        const user = await getUserFromRequest(request);
        if (!user) {
            return NextResponse.json({ message: 'Unauthorized' }, { status: 401 });
        }

        const { roomName } = await request.json();

        if (!roomName || typeof roomName !== 'string' || roomName.trim() === '') {
            return NextResponse.json({ message: '有效的房间名称是必需的' }, { status: 400 });
        }

        const newRoom = await prisma.room.create({
            data: {
                roomName: roomName.trim(),
            },
        });

        return NextResponse.json({ message: '房间创建成功', data: newRoom });

    } catch (error) {
        console.error('创建房间时出错:', error);
        return NextResponse.json({ message: '服务器内部错误' }, { status: 500 });
    }
}
