import { NextRequest } from 'next/server';
import jwt from 'jsonwebtoken';

const JWT_SECRET = process.env.JWT_SECRET || 'jinitaimeijinitaimeijinitaimei';

export interface UserPayload {
  userId: number;
}

export function getUserFromRequest(req: NextRequest): UserPayload | null {
  const token = req.cookies.get('auth_token')?.value;

  if (!token) {
    return null;
  }

  try {
    const decoded = jwt.verify(token, JWT_SECRET) as UserPayload;
    return decoded;
  } catch (error) {
    console.error('JWT 验证失败:', error);
    return null;
  }
}

