import { NextRequest, NextResponse } from 'next/server';
import { getUserFromRequest } from '@/lib/auth';
import prisma from '@/lib/prisma';

export async function POST(request: NextRequest) {
    try {
        const user = await getUserFromRequest(request);
        if (!user) {
            return NextResponse.json({ message: 'Unauthorized' }, { status: 401 });
        }

        const { roomId } = await request.json();

        if (!roomId || typeof roomId !== 'number') {
            return NextResponse.json({ message: '有效的 Room ID 是必需的' }, { status: 400 });
        }
        
        const room = await prisma.room.findUnique({
                    where: { roomId },
                });
        if (!room) {
            return NextResponse.json({ message: '房间未找到' }, { status: 404 });
        }
        if(user.userId !== room.roomcreatorId){
            return NextResponse.json({ message: 'Unauthorized' }, { status: 401 });
        }

        await prisma.$transaction([
            prisma.message.deleteMany({
                where: { roomId: roomId },
            }),
            prisma.room.delete({
                where: { roomId: roomId },
            }),
        ]);

        return NextResponse.json({ message: '房间删除成功' });
    } catch (error) {
        console.error('删除房间时出错:', error);
        return NextResponse.json({ message: '服务器内部错误' }, { status: 500 });
    }
}
