#include "graphics.h"
#include "extgraph.h"
#include "imgui.h"

double NowX, NowY, StartX, StartY, EndX , EndY;

void display() {
	SetPenColor("Black");
	MovePen(ScaleXInches(StartX), ScaleYInches(StartY));
	DrawLine(ScaleXInches(EndX)-ScaleXInches(StartX), ScaleYInches(EndY)-ScaleYInches(StartY));
	StartX = EndX;
	StartY = EndY;	
}

void MyMouseEvent(int x, int y, int button, int event) {
        if (event == BUTTON_DOWN)
		{
            StartX = x;
            StartY = y;
            EndX = x;
            EndY = y;
            printf("%lf,%lf\n", StartY, ScaleYInches(StartY));
        }
		else if (event == BUTTON_UP) 
		{
            StartX = -1;
            StartY = -1;
            EndX = -1;
            EndY = -1;
        } 
		else if (event == MOUSEMOVE && StartX != -1 && StartY != -1) 
		{
            EndX = x;
            EndY = y;
            display();
        }
    
}

void Main() {
	SetWindowTitle("draw by mouse");
	InitGraphics();
	SetEraseMode(FALSE);
	double w = GetWindowWidth();
	double h = GetWindowHeight();
	StartX = -1;
	StartY = -1;
	EndX = -1;
	EndY = -1;
	registerMouseEvent(MyMouseEvent);
}
