#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stddef.h>
#include <windows.h>
#include <olectl.h>
#include <mmsystem.h>
#include <wingdi.h>
#include <ole2.h>
#include <ocidl.h>
#include <winuser.h>
#include <conio.h>

#include "graphics.h"
#include "extgraph.h"
#include "genlib.h"
#include "simpio.h"
#include "strlib.h"
#include "linkedlist.h"
#include "imgui.h"
#include "game.h"
#include "homepage.h"
#include "game.h"
#include "draw.h"


double turn(double angle, double current_angle)
{
    current_angle += angle;
    while (current_angle > 360.0)
    {
        current_angle -= 360.0;
    }
    return current_angle;
}

void move(double distance, double current_angle)
{
    double x = GetCurrentX();
    double y = GetCurrentY();
    MovePen(x + distance * cos(current_angle * 3.14 / 180), y + distance * sin(current_angle * 3.14 / 180));
}

void forward(double distance, double current_angle)
{
    DrawLine(distance * cos(current_angle * 3.14 / 180), distance * sin(current_angle * 3.14 / 180));
}

void draw_piece(void)
{
    double a = GetFontHeight() * 20;
    double width = GetWindowWidth();
    double height = GetWindowHeight();
    double x, y, angle, now_num;
    FILE *fp;
    if ((fp = fopen("game", "r")) == NULL)
    {
        printf("error");
        exit(0);
    }
    while (feof(fp) == 0)
    {
        fscanf(fp, "%lf %lf %lf %lf\n", &now_num, &angle, &x, &y);
        //    printf("%lf\n", now_num);
        SetPenColor("blue");
        switch ((int)now_num + 1)
        {
        case 1:
        case 2:
        {
            MovePen(x, y);
            StartFilledRegion(1);
            forward(a / sqrt(2), angle);
            angle = turn(-135 + 360, angle);
            forward(a, angle);
            angle = turn(-135 + 360, angle);
            forward(a / sqrt(2), angle);
            angle = turn(-90 + 360, angle);
            EndFilledRegion();
            break;
        }
        case 3:
        {
            MovePen(x, y);
            StartFilledRegion(1);
            forward(a / 2, angle);
            angle = turn(360 - 135, angle);
            forward(a / sqrt(2), angle);
            angle = turn(360 - 135, angle);
            forward(a / 2, angle);
            angle = turn(-90 + 360, angle);
            EndFilledRegion();
            break;
        }
        case 4:
        {
            MovePen(x, y);
            StartFilledRegion(1);
            forward(a / sqrt(2) / 2, angle);
            angle = turn(270, angle);
            forward(a / sqrt(2) / 2, angle);
            angle = turn(270, angle);
            forward(a / sqrt(2) / 2, angle);
            angle = turn(270, angle);
            forward(a / sqrt(2) / 2, angle);
            angle = turn(270, angle);
            EndFilledRegion();
            break;
        }
        case 5:
        {
            MovePen(x, y);
            StartFilledRegion(1);
            forward(a / 2, angle);
            angle = turn(360 - 135, angle);
            forward(a / 2 / sqrt(2), angle);
            angle = turn(360 - 45, angle);
            forward(a / 2, angle);
            angle = turn(360 - 135, angle);
            forward(a / 2 / sqrt(2), angle);
            angle = turn(-45 + 360, angle);
            EndFilledRegion();
            break;
        }
        case 6:
        case 7:
        {
            MovePen(x, y);
            StartFilledRegion(1);
            forward(a / 2 / sqrt(2), angle);
            angle = turn(360 - 135, angle);
            forward(a / 2, angle);
            angle = turn(360 - 135, angle);
            forward(a / 2 / sqrt(2), angle);
            angle = turn(-90 + 360, angle);
            EndFilledRegion();
            break;
        }
        }
        MovePen(x, y);
       // forward(GetFontHeight() / 4, angle);
        SetPenColor("red");
        StartFilledRegion(1);
        DrawArc(GetFontHeight() / 4, 0, 360);
        EndFilledRegion();
    }
    fclose(fp);
}

void draw_figure(num)
{
    double a = GetFontHeight() * 20;
    double width = GetWindowWidth();
    double height = GetWindowHeight();
    double x = width / 10 * 6;
    double y = height / 10 * 4;
    switch (num)
    {
    case 1:
    {
        MovePen(x, y);
        draw_figure_first(a, x, y);
        break;
    }
    case 2:
    {
        break;
    }
    case 3:
    {
        break;
    }
    case 4:
    {
        break;
    }
    case 5:
    {
        break;
    }
    }
}