package controller

import (
	"go-svc-tpl/api/dto"
	"go-svc-tpl/internal/dao"
	"go-svc-tpl/internal/dao/model"
	"net/http"
	"time"

	"github.com/dgrijalva/jwt-go"
	"github.com/gin-gonic/gin"
)

// 解析和验证身份认证令牌
func ParseTokenMidware() gin.HandlerFunc {
	return func(ctx *gin.Context) {

		// 获取authorization header
		tokenString, err := ctx.Cookie("token")
		if err != nil {
			ctx.JSON(dto.ErrGetToken, gin.H{"code": dto.ErrGetToken, "message": "ErrGetToken."})
		}

		// validate token formate
		if tokenString == "" { //|| !strings.HasPrefix(tokenString, "Bearer ") {
			ctx.JSON(http.StatusUnauthorized, gin.H{
				"code":    401,
				"message": "权限不足1",
				"data":    tokenString,
			})
			ctx.Abort()
			return
		}

		// //提取token的有效部分（"Bearer "共占7位)
		// tokenString = tokenString[7:]

		token, claims, err := ParseToken(tokenString)
		if err != nil || !token.Valid {
			ctx.JSON(http.StatusUnauthorized, gin.H{"code": 401, "message": "权限不足2", "data": tokenString})
			ctx.Abort()
			return
		}

		// 验证通过后获取claim 中的userId
		userId := claims.UserId
		DB := dao.DB
		var user model.User

		DB(ctx).Table("Users").Where(&model.User{ID: userId}).First(&user)

		// 用户不存在
		if user.ID == 0 {
			ctx.JSON(http.StatusUnauthorized, gin.H{"code": 401, "message": "权限不足 用户不存在", "data": tokenString})
			ctx.Abort()
			return
		}

		// 用户存在将user的信息写入上下文，方便读取
		ctx.Set("user", user)

		ctx.Next()
	}
}

// jwt加密密钥
var jwtKey = []byte("a_secret_crect")

// token的claim
type Claims struct {
	UserId uint

	Email    string `json:"email"`    // 用户邮箱​
	Name     string `json:"name"`     // 用户名​
	Password string `json:"password"` // 用户密码​
	jwt.StandardClaims
}

// 发放token
func ReleaseToken(user model.User) (string, error) {

	//token的有效期
	expirationTime := time.Now().Add(7 * 24 * time.Hour)

	claims := &Claims{

		//自定义字段
		UserId:   user.ID,
		Email:    user.Email,
		Name:     user.Name,
		Password: user.Password,

		//标准字段
		StandardClaims: jwt.StandardClaims{

			//过期时间
			ExpiresAt: expirationTime.Unix(),
			//发放的时间
			IssuedAt: time.Now().Unix(),
			//发放者
			Issuer: "127.0.0.1",
			//主题
			Subject: "user token",
		},
	}

	//使用jwt密钥生成token
	token := jwt.NewWithClaims(jwt.SigningMethodHS256, claims)
	tokenString, err := token.SignedString(jwtKey)

	if err != nil {
		return "", err
	}

	//返回token
	return tokenString, nil
}

// 从tokenString中解析出claims并返回
func ParseToken(tokenString string) (*jwt.Token, *Claims, error) {
	claims := &Claims{}

	token, err := jwt.ParseWithClaims(tokenString, claims, func(token *jwt.Token) (i interface{}, err error) {
		return jwtKey, nil
	})
	return token, claims, err
}

func corsset() gin.HandlerFunc {
	return func(ctx *gin.Context) {
		ctx.Writer.Header().Set("Access-Control-Allow-Origin", "*")
		ctx.Writer.Header().Set("Access-Control-Allow-Credentials", "true")
		ctx.Writer.Header().Set("Access-Control-Allow-Headers", "Content-Type,AccessToken,X-CSRF-Token, Authorization, Token")
		ctx.Writer.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, PATCH, DELETE")
		ctx.Writer.Header().Set("Access-Control-Expose-Headers", "Content-Length, Access-Control-Allow-Origin, Access-Control-Allow-Headers, Content-Type")
		ctx.Writer.Header().Set("Access-Control-Max-Age", "172800")
		ctx.Writer.Header().Set("Access-Control-Allow-Credentials", "true")

		if ctx.Request.Method == "OPTIONS" {
			ctx.AbortWithStatus(200)
		}
		ctx.Next()
	}
}
