# short-link backend
xlab暑期的大实习项目，基于[go-svc-tpl](./docs/design.md) 框架构成，前后端分离，实现注册、登录、短连接生成、更新等操作。
> 在实现这个项目的过程中，真感觉经历了千辛万苦。
但讲实话，完整地经历整个流程下来，确实学到了不少东西（虽然大部分仅仅学了个皮毛）


## 关于我
（

## 实现功能：

### 用户
- 注册
- 登录与登出
- 获取验证码
- 获取用户信息（
- 修改用户信息（
- 修改用户密码（

### 短连接
- 创建短连接
- 删除短连接
- 获取短连接信息
- 更新短连接
- 禁用短连接（
- 获取短连接列表（

### 服务端
- 短连接重定向
- 存验证码图片

## 本项目使用的主要软件包
1. gin：gin 是一个用 Go （Golang） 编写的 HTTP Web 框架。它具有类似Martini的API，性能要好得多 - 速度提高了40倍。如果你需要一个粉碎性的表演，给自己买一些杜松子酒。
2. JWT：JSON Web 令牌是一种开放的行业标准 RFC 7519 方法，用于在双方之间安全地表示声明。用于访问令牌和刷新令牌。
3. testify：一个具有常见断言和模拟的工具包，与标准库配合得很好。
4. gorm: GORM是一个基于Go语言的ORM（对象关系映射）库，它提供了简单而强大的方式来操作数据库。GORM可以与多种数据库进行集成，包括MySQL、PostgreSQL、SQLite等。它提供了丰富的功能，如模型定义、查询构建、事务管理等，使得在Go应用程序中使用数据库变得更加方便和高效。
5. MySQL: MySQL是一种开源的关系型数据库管理系统，它是最流行的数据库之一。MySQL使用SQL（结构化查询语言）作为其查询语言，并提供了高性能、可靠性和可扩展性。它支持多种操作系统，并且可以与多种编程语言进行集成。
### 没有 JWT 身份验证中间件的公共 API 请求流

![Public API Request Flow](https://github.com/amitshekhariitbhu/go-backend-clean-architecture/blob/main/assets/go-arch-public-api-request-flow.png?raw=true)

### 具有 JWT 身份验证中间件的私有 API 请求流

> 用于访问令牌验证的 JWT 身份验证中间件。
![Private API Request Flow](https://github.com/amitshekhariitbhu/go-backend-clean-architecture/blob/main/assets/go-arch-private-api-request-flow.png?raw=true)
## 如何运行该项目？
我们可以在没有安装go或没有安装Docker的情况下运行该项目，在这里我们提供两种方法。（很不幸，您的两种方法都需要安装MySQL）
- 克隆此项目
```
# Move to your workspace
cd your-workspace

# Clone this project into your workspace
git clone http://xlab.zju.edu.cn/git/future/backend

# Move to the project root directory
cd backend
```


### 不用Docker运行

1. git clone 所有文件，进入根目录
2. 如果您的计算机未安装`go`,请安装
3. 如果您的计算机未按照`MySQL`,请安装
4. 进入项目所在根目录 执行go run main.go
5. 访问localhost:8080/ping测试
6. 运行前端项目后访问localhost:8000

### 使用Docker运行

1. 如果您的计算机未配置好`MySQL`,请配置
2. 按照config_demo.yaml修改你的本地mysql对应的密码、ip和数据库。
3. 安装Docker,在项目根目录下运行
```
docker run --net=bridge -p 8080:8080 --name=shortlink shortlink
```
4. 访问localhost:8080/ping测试
5. 运行前端项目后访问localhost:8000


## 如何运行测试？
```
# 进行测试
go test ./...
```
>我更提倡直接用每个test函数旁边的go test一个一个测试，比较测试嘛，肯定要报错的，一堆错误一起报未免不太美观（
## 项目结构图
```
backend
├─ .git
├─ .gitignore
├─ api
│  ├─ dto
│  │  ├─ errcode.go
│  │  ├─ general.go
│  │  ├─ link.go
│  │  ├─ server.go
│  │  └─ user.go
│  ├─ init.go
│  └─ route
│     ├─ link.go
│     ├─ route.go
│     ├─ server.go
│     └─ user.go
├─ cmd
│  ├─ init.go
│  └─ root.go
├─ dockerfile
├─ docs
│  └─ design.md
├─ go.mod
├─ go.sum
├─ internal
│  ├─ controller
│  │  ├─ link.go
│  │  ├─ link_user_test.go
│  │  ├─ mid.go
│  │  ├─ server.go
│  │  ├─ testDB.go
│  │  └─ user.go
│  ├─ dao
│  │  ├─ complex_crud.go
│  │  ├─ dao.go
│  │  └─ model
│  │     ├─ link.go
│  │     └─ user.go
│  └─ service
│     └─ .gitkeep
├─ main.go
├─ README.md
└─ utils
   ├─ logger
   │  └─ logger.go
   └─ stacktrace
      ├─ cause.go
      ├─ cause_test.go
      ├─ cleanpath
      │  ├─ gopath.go
      │  └─ gopath_test.go
      ├─ codes_for_test.go
      ├─ doc.go
      ├─ format.go
      ├─ format_test.go
      ├─ functions_for_test.go
      ├─ LICENSE
      ├─ README.md
      ├─ stacktrace.go
      └─ stacktrace_test.go

```

## todo
- 等待前端功能补足（×）  自己写个新前端（ 
- 不用登录就能创建短连接
## 如果这个项目无论如何都对你有帮助，通过在这个项目✌️上放一个⭐来表达你的爱 ❤️