import './CommentTest.css';
import React, { useState } from 'react';

function CommentTest() {
    function handleSubmit(event) {
        event.preventDefault();
        const name = event.target.elements.name.value.trim();
        const content = event.target.elements.content.value.trim();
        if (!name || !content) {
            alert('请输入完整的用户名和评论内容！');
            return;
        }
        fetch('http://localhost:8080/comment/add', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ name, content }),
        })
        .then(response => response.json())
        .then(data => {
            if (data.code === 0) {
                event.target.reset();
                window.location.reload();
            } else {
                alert('评论提交失败: ' + (data.message || '未知错误'));
            }
        })
        .catch(() => alert('网络错误，评论提交失败'));
    }

    return (
        <div>
            <form className='chat-form' onSubmit={handleSubmit}> 
                <div className='chat-box'>
                <span className='title'>User Name</span>
                <input type="text" className='name-input' name="name" placeholder="Enter your name" />
                <span className='title'>Comment</span>
                <input type="text" className='comment-input' name="content" placeholder="Enter your comment" />
                <button type="submit" className='send-button'>Send</button>
                </div>
            </form>
        </div>
    )
}

export default CommentTest;