import React, { useEffect, useState } from 'react';
import Comment from './Comment';
import './CommentList.css';

function CommentList() {
    const [comments, setComments] = useState([]);
    const [total, setTotal] = useState(0);
    const [page, setPage] = useState(1);
    const [size, setSize] = useState(3);
    const [inputPage, setInputPage] = useState(1);

    useEffect(() => {
        fetch(`http://localhost:8080/comment/get?page=${page}&size=${size}`)
            .then(response => response.json())
            .then(data => {
                if (data && data.code === 0 && data.data && Array.isArray(data.data.comments)) {
                    setComments(data.data.comments);
                    setTotal(data.data.total || 0);
                } else {
                    setComments([]);
                }
            })
            .catch(error => console.error('Error fetching comments:', error));
    }, [page, size]);

    function onDelete(commentId) {
        fetch(`http://localhost:8080/comment/delete?id=${commentId}`)
            .then(response => response.json())
            .then(data => {
                if (data.code === 0) {
                    if (comments.length === 1 && page > 1) {
                        setPage(page - 1);
                    } else {  
                        fetch(`http://localhost:8080/comment/get?page=${page}&size=${size}`)
                            .then(response => response.json())
                            .then(data => {
                                if (data && data.code === 0 && data.data && Array.isArray(data.data.comments)) {
                                    setComments(data.data.comments.reverse());
                                    setTotal(data.data.total || 0);
                                } else {
                                    setComments([]);
                                }
                            });
                    }
                } else {
                    console.error('Error deleting comment:', data.message);
                }
            })
            .catch(error => console.error('Error deleting comment:', error));
    }

    function handleJumpPage() {
        // 跳转到指定页
        if (inputPage >= 1 && inputPage <= Math.ceil(total / size)) {
            setPage(inputPage);
        } else {
            alert('页码超出范围');
        }
    }

    return (
        <div className="comment-list">
            {comments.map((comment) => (
                <Comment
                    key={comment.id}
                    name={comment.name}
                    content={comment.content}
                    onDelete={() => onDelete(comment.id)}
                />
            ))}
            <div className="pagination">
                <button onClick={() => setPage(page - 1)} disabled={page === 1} className='left-button'>&larr;</button>
                <span className='page-index'>Page {page} of {Math.ceil(total / size)}</span>
                <button onClick={() => setPage(page + 1)} disabled={page * size >= total} className='right-button'>&rarr;</button>
                <input
                    type="number"
                    min="1"
                    max={Math.ceil(total / size)}
                    value={inputPage}
                    onChange={e => setInputPage(Number(e.target.value))}
                    style={{ width: 50, marginLeft: 8, marginRight: 8 }}
                />
                <button onClick={handleJumpPage}>跳转</button>
            </div>
        </div>
    );
}

export default CommentList;