import React, { useEffect, useState } from 'react';
import Comment from './Comment';
import './CommentList.css';

function CommentList() {
    const [comments, setComments] = useState([]);
    const [total, setTotal] = useState(0);
    const [page, setPage] = useState(1);
    const [size, setSize] = useState(10); // 每页显示的评论数量

    useEffect(() => {
        // 向后端请求数据
        fetch(`http://localhost:8080/comment/get?page=${page}&size=${size}`) // 替换为实际的后端 API 地址
            .then(response => response.json())
            .then(data => {
                if (data && data.code === 0 && data.data && Array.isArray(data.data.comments)) {
                    setComments(data.data.comments); // 确保 comments 是数组
                    setTotal(data.data.total || 0);
                } else {
                    console.error('Unexpected response structure:', data);
                    setComments([]); // 设置为空数组以避免错误
                }
            })
            .catch(error => console.error('Error fetching comments:', error));
    }, []);

    function onDelete(commentId) {
        // 删除评论的逻辑
        fetch(`http://localhost:8080/comment/delete?id=${commentId}`)
            .then(response => response.json())
            .then(data => {
                if (data.code === 0) {
                    // 成功删除后，重新获取评论列表
                    setComments(comments.filter(comment => comment.id !== commentId));
                } else {
                    console.error('Error deleting comment:', data.message);
                }
            })
            .catch(error => console.error('Error deleting comment:', error));
    }

    return (
        <div className="comment-list">
            {comments.map((comment) => (
                <Comment
                    key={comment.id} // 假设每个评论都有唯一的 id
                    name={comment.name}
                    content={comment.content}
                    onDelete={() => onDelete(comment.id)}
                />
            ))}
        </div>
    );
}

export default CommentList;