import './CommentTest.css';
import React, { useState } from 'react';

function CommentTest() {
    function handleSubmit(event) {
        event.preventDefault(); 
        const name = event.target.elements.name.value;
        const content = event.target.elements.content.value;

        fetch('http://10.194.23.96:8080/comment/add', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ name, content }), 
        })
        .then(response => response.json())
        .then(data => {
            if (data.code === 0) {
                console.log('Comment added successfully:', data.data);
                event.target.reset();
                window.location.reload();
            } else {
                console.error('Error adding comment:', data.message);
            }
        })
        console.log('Name:', name);
        console.log('Comment:', content);
    }

    return (
        <div>
            <form className='chat-form' onSubmit={handleSubmit}> 
                <div className='chat-box'>
                <span className='title'>User Name</span>
                <input type="text" className='name-input' name="name" placeholder="Enter your name" />
                <span className='title'>Comment</span>
                <input type="text" className='comment-input' name="content" placeholder="Enter your comment" />
                <button type="submit" className='send-button'>Send</button>
                </div>
            </form>
        </div>
    )
}

export default CommentTest;