import React, { useEffect, useState } from 'react';
import Comment from './Comment';
import './CommentList.css';

function CommentList() {
    const [comments, setComments] = useState([]);
    const [total, setTotal] = useState(0);
    const [page, setPage] = useState(1);
    const [size, setSize] = useState(3);

    useEffect(() => {
        fetch(`http://10.194.23.96:8080/comment/get?page=${page}&size=${size}`)
            .then(response => response.json())
            .then(data => {
                if (data && data.code === 0 && data.data && Array.isArray(data.data.comments)) {
                    setComments(data.data.comments);
                    setTotal(data.data.total || 0);
                } else {
                    console.error('Unexpected response structure:', data);
                    setComments([]);
                }
            })
            .catch(error => console.error('Error fetching comments:', error));
    }, [page]);

    function onDelete(commentId) {
        fetch(`http://10.194.23.96:8080/comment/delete?id=${commentId}`)
            .then(response => response.json())
            .then(data => {
                if (data.code === 0) {
                    setComments(comments.filter(comment => comment.id !== commentId));
                } else {
                    console.error('Error deleting comment:', data.message);
                }
            })
            .catch(error => console.error('Error deleting comment:', error));
    }

    return (
        <div className="comment-list">
            {comments.map((comment) => (
                <Comment
                    key={comment.id}
                    name={comment.name}
                    content={comment.content}
                    onDelete={() => onDelete(comment.id)}
                />
            ))}
            <div className="pagination">
                <button onClick={() => setPage(page - 1)} disabled={page === 1} className='left-button'>&larr;</button>
                <span className='page-index'>Page {page} of {Math.ceil(total / size)}</span>
                <button onClick={() => setPage(page + 1)} disabled={page * size >= total} className='right-button'>&rarr;</button>
            </div>

        </div>
    );
}

export default CommentList;