# 聊天室 Pro

一个基于 Next.js + TypeScript + Prisma 的全栈聊天应用。

## 功能特性

- 🔐 **用户认证**：注册、登录、JWT 身份验证
- 💬 **实时聊天**：支持多房间聊天，消息实时更新
- 🏠 **房间管理**：创建、删除聊天房间
- 👤 **自定义昵称**：用户可设置聊天昵称
- 📱 **响应式设计**：支持桌面和移动端
- 🐳 **Docker 部署**：完整的容器化解决方案

## 技术栈

### 前端
- **Next.js 14**：React 全栈框架，使用 App Router
- **TypeScript**：类型安全的 JavaScript
- **SWR**：数据获取和缓存库
- **CSS Modules**：样式管理

### 后端
- **Next.js API Routes**：后端 API 实现
- **Prisma ORM**：数据库操作和管理
- **SQLite**：轻量级数据库（可换成其他数据库）
- **JWT**：用户身份验证
- **bcryptjs**：密码加密

### 部署
- **Docker**：容器化部署
- **Docker Compose**：多服务编排

## 快速开始

### 本地开发

1. **克隆项目**
   ```bash
   git clone <repository-url>
   cd chatroom_pro
   ```

2. **安装依赖**
   ```bash
   npm install
   ```

3. **设置环境变量**
   ```bash
   cp .env.example .env.local
   ```
   编辑 `.env.local` 文件，设置必要的环境变量：
   ```
   DATABASE_URL="file:./dev.db"
   JWT_SECRET="your-super-secret-jwt-key"
   NEXTAUTH_SECRET="your-nextauth-secret"
   NEXTAUTH_URL="http://localhost:3000"
   ```

4. **初始化数据库**
   ```bash
   npx prisma generate
   npx prisma migrate dev
   npx prisma db seed
   ```

5. **启动开发服务器**
   ```bash
   npm run dev
   ```

6. **访问应用**
   打开浏览器访问 [http://localhost:3000](http://localhost:3000)

### Docker 部署

1. **使用 Docker Compose 部署**
   ```bash
   docker-compose up -d
   ```

2. **访问应用**
   打开浏览器访问 [http://localhost:3000](http://localhost:3000)

## 演示账号

系统默认创建了以下演示账号：

- **用户名**: `admin` **密码**: `123456`
- **用户名**: `demo` **密码**: `123456`

## 项目结构

```
chatroom_pro/
├── src/
│   ├── app/                    # Next.js App Router 页面
│   │   ├── api/               # API 路由
│   │   │   ├── auth/          # 认证相关 API
│   │   │   ├── room/          # 房间相关 API
│   │   │   └── message/       # 消息相关 API
│   │   ├── globals.css        # 全局样式
│   │   ├── layout.tsx         # 根布局
│   │   └── page.tsx          # 主页面
│   ├── components/            # React 组件
│   │   └── ChatRoom.tsx      # 聊天室主组件
│   ├── contexts/              # React Context
│   │   └── AuthContext.tsx   # 认证上下文
│   ├── lib/                   # 工具库
│   │   ├── api.ts            # API 客户端
│   │   ├── auth.ts           # 认证工具
│   │   └── prisma.ts         # Prisma 客户端
│   └── types/                 # TypeScript 类型定义
│       └── api.ts            # API 类型
├── prisma/                    # 数据库相关
│   ├── migrations/           # 数据库迁移文件
│   ├── schema.prisma         # 数据库模式
│   └── seed.ts              # 种子数据
├── docker-compose.yml         # Docker Compose 配置
├── Dockerfile                # Docker 镜像配置
└── README.md                 # 项目文档
```

## API 接口文档

### 认证相关

#### 用户注册
- **URL**: `/api/auth/register`
- **方法**: `POST`
- **参数**: 
  ```typescript
  {
    username: string;
    password: string;
  }
  ```

#### 用户登录
- **URL**: `/api/auth/login`
- **方法**: `POST`
- **参数**: 
  ```typescript
  {
    username: string;
    password: string;
  }
  ```

### 房间管理

#### 创建房间
- **URL**: `/api/room/add`
- **方法**: `POST`
- **参数**: 
  ```typescript
  {
    user: string;
    roomName: string;
  }
  ```

#### 获取房间列表
- **URL**: `/api/room/list`
- **方法**: `GET`

#### 删除房间
- **URL**: `/api/room/delete`
- **方法**: `POST`
- **参数**: 
  ```typescript
  {
    user: string;
    roomId: number;
  }
  ```

### 消息管理

#### 发送消息
- **URL**: `/api/message/add`
- **方法**: `POST`
- **参数**: 
  ```typescript
  {
    roomId: number;
    content: string;
    sender: string;
  }
  ```

#### 获取房间消息
- **URL**: `/api/room/message/list`
- **方法**: `GET`
- **参数**: `?roomId=number`

#### 获取新消息
- **URL**: `/api/room/message/getUpdate`
- **方法**: `GET`
- **参数**: `?roomId=number&sinceMessageId=number`

## 开发说明

### 数据库模式

项目使用 Prisma ORM 管理数据库，包含以下模型：

- **User**: 用户表，存储用户名和加密密码
- **Room**: 房间表，存储房间信息和创建者
- **Message**: 消息表，存储聊天消息

### 认证机制

使用 JWT (JSON Web Token) 进行用户认证：

1. 用户登录后获得 JWT token
2. 前端将 token 存储在 localStorage
3. 每次 API 请求在 Authorization header 中携带 token
4. 后端验证 token 有效性

### 实时更新

目前使用轮询机制实现消息的实时更新：

- 每秒检查一次新消息
- 使用 SWR 进行数据缓存和更新
- 可以考虑升级到 WebSocket 实现真正的实时通信

## 部署指南

### 环境要求

- Node.js 18+
- Docker（可选）
- Git

### 生产环境配置

1. **设置环境变量**
   ```bash
   DATABASE_URL="your-production-database-url"
   JWT_SECRET="your-production-jwt-secret"
   NEXTAUTH_SECRET="your-production-nextauth-secret"
   NEXTAUTH_URL="your-production-domain"
   ```

2. **数据库迁移**
   ```bash
   npx prisma migrate deploy
   ```

3. **构建应用**
   ```bash
   npm run build
   ```

4. **启动服务**
   ```bash
   npm start
   ```

### Docker 部署

使用提供的 `docker-compose.yml` 文件一键部署：

```bash
docker-compose up -d
```

## 贡献指南

1. Fork 项目
2. 创建功能分支 (`git checkout -b feature/AmazingFeature`)
3. 提交更改 (`git commit -m 'Add some AmazingFeature'`)
4. 推送到分支 (`git push origin feature/AmazingFeature`)
5. 开启 Pull Request

## 许可证

本项目采用 MIT 许可证 - 查看 [LICENSE](LICENSE) 文件了解详情。

## 联系方式

如有问题或建议，请提交 Issue 或联系项目维护者。
