import { NextRequest, NextResponse } from 'next/server'
import { registerUser, generateToken } from '@/lib/auth'
import { RegisterRequest, ApiResponse } from '@/types/api'

export async function POST(request: NextRequest) {
  try {
    const body: RegisterRequest = await request.json()
    const { username, password } = body

    if (!username || !password) {
      return NextResponse.json({
        message: '用户名和密码不能为空',
        code: 1,
        data: null
      } as ApiResponse, { status: 400 })
    }

    if (username.length < 2 || password.length < 6) {
      return NextResponse.json({
        message: '用户名至少2个字符，密码至少6个字符',
        code: 1,
        data: null
      } as ApiResponse, { status: 400 })
    }

    const user = await registerUser(username, password)
    const token = generateToken(user)

    return NextResponse.json({
      message: '注册成功',
      code: 0,
      data: {
        user,
        token
      }
    } as ApiResponse)
  } catch (error) {
    return NextResponse.json({
      message: error instanceof Error ? error.message : '注册失败',
      code: 1,
      data: null
    } as ApiResponse, { status: 400 })
  }
}
