import { NextRequest, NextResponse } from 'next/server'
import { loginUser, generateToken } from '@/lib/auth'
import { LoginRequest, ApiResponse } from '@/types/api'

export async function POST(request: NextRequest) {
  try {
    const body: LoginRequest = await request.json()
    const { username, password } = body

    if (!username || !password) {
      return NextResponse.json({
        message: '用户名和密码不能为空',
        code: 1,
        data: null
      } as ApiResponse, { status: 400 })
    }

    const user = await loginUser(username, password)
    const token = generateToken(user)

    return NextResponse.json({
      message: '登录成功',
      code: 0,
      data: {
        user,
        token
      }
    } as ApiResponse)
  } catch (error) {
    return NextResponse.json({
      message: error instanceof Error ? error.message : '登录失败',
      code: 1,
      data: null
    } as ApiResponse, { status: 401 })
  }
}
