#!/bin/bash

echo "🚀 开始设置聊天室 Pro 项目..."

# 检查 Node.js 是否安装
if ! command -v node &> /dev/null; then
    echo "❌ Node.js 未安装，请先安装 Node.js 18+)"
    exit 1
fi

# 检查 npm 是否安装
if ! command -v npm &> /dev/null; then
    echo "❌ npm 未安装，请先安装 npm"
    exit 1
fi

echo "📦 安装依赖..."
npm install

echo "🗃️ 生成 Prisma 客户端..."
npx prisma generate

echo "🗄️ 运行数据库迁移..."
npx prisma migrate dev --name init

echo "🌱 填充种子数据..."
npx prisma db seed

echo "✅ 设置完成！"
echo ""
echo "🎉 您现在可以启动开发服务器："
echo "   npm run dev"
echo ""
echo "📱 然后在浏览器中访问："
echo "   http://localhost:3000"
echo ""
echo "👤 演示账号："
echo "   用户名: admin, 密码: 123456"
echo "   用户名: demo, 密码: 123456"
