import { PrismaClient } from '@prisma/client'
import bcrypt from 'bcryptjs'

const prisma = new PrismaClient()

async function main() {
  console.log('开始初始化数据库...')
  
  // 创建演示用户
  const hashedPassword = await bcrypt.hash('123456', 12)
  
  const user1 = await prisma.user.upsert({
    where: { username: 'admin' },
    update: {},
    create: {
      username: 'admin',
      password: hashedPassword,
    },
  })

  const user2 = await prisma.user.upsert({
    where: { username: 'demo' },
    update: {},
    create: {
      username: 'demo',
      password: hashedPassword,
    },
  })

  // 创建演示房间
  const room1 = await prisma.room.upsert({
    where: { id: 1 },
    update: {},
    create: {
      name: '欢迎大厅',
      creatorId: user1.id,
    },
  })

  const room2 = await prisma.room.upsert({
    where: { id: 2 },
    update: {},
    create: {
      name: '技术讨论',
      creatorId: user1.id,
    },
  })

  // 创建演示消息
  await prisma.message.upsert({
    where: { id: 1 },
    update: {},
    create: {
      content: '欢迎来到聊天室！',
      roomId: room1.id,
      senderId: user1.id,
    },
  })

  await prisma.message.upsert({
    where: { id: 2 },
    update: {},
    create: {
      content: '大家好，这里是技术讨论区',
      roomId: room2.id,
      senderId: user1.id,
    },
  })

  console.log('数据库初始化完成！')
  console.log('演示账号：')
  console.log('用户名: admin, 密码: 123456')
  console.log('用户名: demo, 密码: 123456')
}

main()
  .then(async () => {
    await prisma.$disconnect()
  })
  .catch(async (e) => {
    console.error(e)
    await prisma.$disconnect()
    process.exit(1)
  })
