# 快速启动指南

## 🚀 三步启动聊天室

### 方法一：自动设置（推荐）

**Windows 用户：**
```bash
setup.bat
```

**Linux/Mac 用户：**
```bash
chmod +x setup.sh
./setup.sh
```

### 方法二：手动设置

1. **安装依赖**
   ```bash
   npm install
   ```

2. **初始化数据库**
   ```bash
   npx prisma generate
   npx prisma migrate dev --name init
   npx prisma db seed
   ```

3. **启动服务器**
   ```bash
   npm run dev
   ```

### 方法三：Docker 部署

```bash
docker-compose up -d
```

## 🌐 访问应用

打开浏览器访问：[http://localhost:3000](http://localhost:3000)

## 👤 演示账号

- **用户名**: `admin` **密码**: `123456`
- **用户名**: `demo` **密码**: `123456`

## 🎯 使用说明

1. **注册/登录**：首次使用请注册账号，或使用演示账号登录
2. **设置昵称**：登录后需要设置聊天昵称
3. **加入房间**：在左侧房间列表中选择房间
4. **发送消息**：在底部输入框输入消息并发送
5. **创建房间**：点击"+ 添加房间"按钮创建新房间
6. **删除房间**：右键点击房间可删除（仅创建者可删除）

## 🔧 开发命令

- `npm run dev` - 启动开发服务器
- `npm run build` - 构建生产版本
- `npm run start` - 启动生产服务器
- `npm run lint` - 代码检查
- `npx prisma studio` - 打开数据库管理界面

## 📱 功能特性

✅ 用户注册和登录  
✅ 自定义聊天昵称  
✅ 创建和删除聊天房间  
✅ 实时消息更新  
✅ 响应式设计  
✅ Docker 容器化部署  

## 🐛 常见问题

**Q: 数据库文件在哪里？**  
A: SQLite 数据库文件位于 `prisma/dev.db`

**Q: 如何重置数据库？**  
A: 删除 `prisma/dev.db` 文件，然后重新运行 `npx prisma migrate dev` 和 `npx prisma db seed`

**Q: 如何更改数据库类型？**  
A: 修改 `prisma/schema.prisma` 中的 `datasource` 配置

**Q: 端口被占用怎么办？**  
A: 修改 `package.json` 中的 dev 脚本，添加 `-p 端口号` 参数
