// 基础数据类型
export interface Message {
  messageId: number;  // 消息 id
  roomId: number;     // 房间 id
  sender: string;     // 发送人的 username
  content: string;    // 消息内容
  time: number;       // 消息发送时间戳
}

export interface RoomPreviewInfo {
  roomId: number;
  roomName: string;
  // UPDATE 20230814: 这里增加了 null 的可能性
  lastMessage: Message | null;
}

// API 请求参数类型
export interface RoomAddArgs {
  user: string;
  roomName: string;
}

export interface RoomDeleteArgs {
  user: string;
  roomId: number;
}

export interface MessageAddArgs {
  roomId: number;
  content: string;
  sender: string;
}

export interface RoomMessageListArgs {
  roomId: number;
}

export interface RoomMessageGetUpdateArgs {
  roomId: number;
  sinceMessageId: number;
}

// API 响应类型
export interface ApiResponse<T = any> {
  message: string;
  code: number;
  data: T | null;
}

export interface RoomAddRes {
  roomId: number;
}

export interface RoomListRes {
  rooms: RoomPreviewInfo[];
}

export interface RoomMessageListRes {
  messages: Message[];
}

export interface RoomMessageGetUpdateRes {
  messages: Message[];
}

// 用户相关类型
export interface User {
  id: number;
  username: string;
}

export interface LoginRequest {
  username: string;
  password: string;
}

export interface RegisterRequest {
  username: string;
  password: string;
}
