package middleware

import (
	"fmt"

	"github.com/labstack/echo/v4"
	"github.com/sirupsen/logrus"
)

func Auth(next echo.HandlerFunc) echo.HandlerFunc {
	return func(c echo.Context) error {
		mylogger(c)
		uid := getUid(c)
		c.Set("uid", uid)
		return next(c)
	}
}

/*
向文件或 stdout 输出详细的日志，记录用户的 User-Agent、IP 地址、访问时间、访问路径等信息
User-Agent,访问路径,暂且无法实现
*/
func mylogger(c echo.Context) {
	//c.GET("User-Agent")
	userAgent := c.Get("User-Agent")
	ip := echo.ExtractIPDirect()(c.Request())
	msg := "User-Agent:" + fmt.Sprint(userAgent) + ",ip:" + ip + ",path:" + c.Path()
	logrus.Println(msg)
}

// 检测 uid 是否有效
func isUidValid(uid string) bool {
	if uid == "" {
		return false
	}
	return true
}

// 从报文中获得uid,给新用户分配uid
func getUid(c echo.Context) interface{} {
	cookie, err := c.Cookie("User")
	if err != nil || !isUidValid(cookie.Value) {
		logrus.Println("uid invalid,分配新uid")
		return 114514
	} else {
		return cookie.Value
	}
}
