package response

import (
	"net/http"

	"github.com/labstack/echo/v4"
)

type Response struct {
	Code int         `json:"code"`
	Msg  string      `json:"msg"`
	Type string      `json:"type"`
	Data interface{} `json:"data"`
}

type Response2 struct {
	Code int    `json:"code"`
	Msg  string `json:"msg"`
	Name string `json:"fileName"`
	Type string `json:"fileType"`
	Url  string `json:"url"`
}

type Response3 struct {
	Code int         `json:"code"`
	Msg  string      `json:"msg"`
	Name string      `json:"name"`
	Type string      `json:"type"`
	Data interface{} `json:"data"`
}

func SendResponse(c echo.Context, code int, msg string, data ...interface{}) error {
	return c.JSON(http.StatusOK, Response{
		Code: code,
		Msg:  msg,
		Data: data,
	})
}

func SendResponse2(c echo.Context, code int, msg string, name string, typ string, url string, data ...interface{}) error {
	return c.JSON(http.StatusOK, Response2{
		Code: code,
		Msg:  msg,
		Name: name,
		Type: typ,
		Url:  url,
	})
}

func SendResponse3(c echo.Context, code int, msg string, name string, typ string, data ...interface{}) error {
	return c.JSON(http.StatusOK, Response3{
		Code: code,
		Msg:  msg,
		Name: name,
		Type: typ,
		Data: data,
	})
}

// 返回err
func SendResponse4(c echo.Context, err error) error {
	return c.JSON(http.StatusBadRequest, err.Error())
}
