import React, { useState, useEffect, useRef } from 'react';
import { Input } from 'antd';
import hljs from 'highlight.js/lib/core';
import javascript from 'highlight.js/lib/languages/javascript';
import 'highlight.js/styles/atom-one-dark.css';

hljs.registerLanguage('javascript', javascript);

export let text = '';


const Code = ({ onTextChange }) => {
  const [value, setValue] = useState('');
  const codeRef = useRef(null);

  const onChange = (e) => {
    text = e.target.value;
    setValue(text);
  };

  useEffect(() => {
    hljs.highlightAll();
  }, [value]);

  return (
    <>
      <Input.TextArea
        value={value}
        onChange={onChange}
        placeholder="paste the file here"
        
        style={{ width: '80%', height: '200px' }}
        ref={codeRef}
      />
      
      <pre ref={codeRef}>
        <code  className="hljs javascript" style={{ width: '80%', height: '200px' }}>
          {value}
        </code>
      </pre>
    </>
  );
};

export default Code;
