package response

import (
	"net/http"

	"github.com/labstack/echo/v4"
)

type Msg struct {
	Name    string
	Type    string
	Content string
	Url     string
}

type Msg2 struct {
	Url  string
	Name string
	Size int
}

type Response struct {
	Code int         `json:"Code"`
	Msg  string      `json:"Msg"`
	Data interface{} `json:"Data"`
}

type Response1 struct {
	Code int    `json:"Code"`
	Msg  string `json:"Msg"`
	Data Msg    `json:"Data"`
}

type Response2 struct {
	Code int    `json:"Code"`
	Msg  string `json:"Msg"`
	Data Msg2   `json:"Data"`
}

func SendResponse(c echo.Context, code int, msg string, data ...interface{}) error {
	return c.JSON(http.StatusOK, Response{
		Code: code,
		Msg:  msg,
		Data: data,
	})
}

func SendResponse1(c echo.Context, code int, msg string, data Msg) error {
	return c.JSON(http.StatusOK, Response1{
		Code: code,
		Msg:  msg,
		Data: data,
	})
}

func SendResponse2(c echo.Context, code int, msg string, data Msg2) error {
	return c.JSON(http.StatusOK, Response2{
		Code: code,
		Msg:  msg,
		Data: data,
	})
}

// 返回err
func SendResponse4(c echo.Context, err error) error {
	return c.JSON(http.StatusBadRequest, err.Error())
}
