// JavaScript source code
import React from 'react';
import axios from 'axios';

//const webSite="http:"

//请求拦截器 一个回调
axios.interceptors.request.use((config) => {
    config.baseURL = 'http://localhost:8089'//修改baseURL
    return config
})
//响应拦截器 两个回调
axios.interceptors.response.use(
    //响应成功回调
    (res)=> {
    console.log('success')
        return res.data
},
    //响应失败回调
    (err) => {
        return Promise.reject(err)
        return new Promise(() => { })//中断
    }
)

async function test1() {
    //get
    //简化写法 let result = await axios.get('/persons')//await等成功de值
    //console.log(result.data.data)
    try {
        let result = await axios({
            url: '/persons234',
            method: 'GET'
        })
        console.log('成功了', result)
    } catch (error) {
        console.log('失败了', error)
    }
}//获取所有人 get无参数
//常见的request方式
//GET查 POST增 PUT改 DELETE删

//请求参数
//query参数 （查询字符串参数）
//params 参数
//请求体参数（json编码、urlencoded编码）  4*3除了GET+请求体

//GET 获取
async function test2(){//获取一个人 query参数
    //参数直接写在路径 simple
    //let result = await axios.get('/person?id=123456789')
    //or写在配置项
    let result = await axios.get('/person', {
        params: {
            id: '123123'
        }
    })
    console.log(result)
}
//GET params 通过age获得一堆人
async function test3() {
    //简单写法 没有配置项写法
    //let result = await axios.get('/filter/18/男/学生')//params没有问号
    //console.log(result)
    //复杂写法
    let result = await axios({
        url: '/filter/19',
    method: 'GET'
    })
    console.log(result)

}

async function posttext1(text,time,ttyy,pass) {
    //ez
    //axios.post('/file', { name: 'shuo', age: 18 })//option自带请求
    //请求体参数 url[data[config]]

    //urlencoded编码
    //let result = await axios.post('/person','name=老八&age=32')

    //复杂
    let result = await axios({
        url: '/api/file/upload',
        method: 'post',
        params: {//query
            FileName: "i",// 文件名,比如 xxx
            Type:  ttyy ,//文件类型，比如c
            Expiration: time,//过期时间,单位
            User:     "",//用户名
            Passwd: pass,//密码
            Content: text// 传输的文本，源代码
        },
        
        //data: 'name=xx&age=xx'//请求体参数
    })
    console.log(result)
}

async function posttext(text,fileContent,time,ttyy,pass) {
    var content="";
    if(text==""){
        if(fileContent==""){
            content="";
        }else{
            content=fileContent;
        }
    }else{
        content=text;
    }

    if(time==""){
        var curTime=new Date();
        var timeD=new Date(curTime.setMinutes(curTime.getMinutes()+30));
        time=timeD.toISOString();
    }else{
        time=new Date(time).toISOString();
    }
    //var content=fileContent;
    fetch('http://localhost:8089/api/text/upload', {
        method: 'POST',
        body: JSON.stringify({
            Name: "i",// 文件名,比如 xxx
            FileType:  ttyy ,//文件类型，比如c
            Expiration: time,//过期时间,单位
            User:     "",//用户名
            Passwd: pass,//密码
            Content: content// 传输的文本，源代码
        }),
        headers: {
          'Content-type': 'application/json; charset=UTF-8',
          'Cookie': document.cookie // 在请求头中带上cookie
        },
      })
      .then((response) => response.json())
      //.then((data) =>{console.log(data)})
      .catch((err) => {
          console.log(err.message);
      });
         
}

async function getText(url, pass) {
    try {
      const response = await fetch('http://localhost:8089/api/text/download', {
        method: 'POST',
        body: JSON.stringify({
          Url: url,
          Passwd: pass, //密码
        }),
        headers: {
          'Content-type': 'application/json; charset=UTF-8',
          'Cookie': document.cookie // 在请求头中带上cookie
        },
      });
  
      const data = await response.json();
      return data;
    } catch (err) {
      console.log(err.message);
      return null;
    }
 }
  


export default posttext;
export { posttext, getText }
//PUT 更新

//DELETE 删除