import React, { useState } from 'react';
import { Input } from 'antd';
import { Divider } from 'antd';
import { UploadOutlined } from '@ant-design/icons';
import { Button, Popconfirm, Space, Upload } from 'antd';
import { Layout } from 'antd';
import { Typography } from 'antd';
import ViewSelect from './components/viewselect'
import Pass from './components/password';
import Time from './components/time';
import Code from './components/code';
import Submit from './components/submit';
import Times from './components/times';
import Type from './components/type';
import Up from './components/upload';
import Link from './components/link';
import Download from './components/download';
import axios from 'axios';

const { Title } = Typography;
const { Header, Footer, Sider, Content } = Layout;



export default function App() {
  const [show,setShow]=useState(1);

  return (
    <Layout style={{ minHeight: '100vh', backgroundColor: "#f2f2f2" }}>
      <Header>
        <Title style={{ color: '#444444'}}>Pastebin</Title>
      </Header>

      <Content style={{ padding: '50px' }}>
        <div style={{ display: 'flex', flexDirection: 'column', alignItems: 'center' }}>
          <Title level={4}>Submit files and generate links to share.</Title>
          <ViewSelect show={show} setShow={setShow}></ViewSelect>
          {show==1?(// upload
            <Space size="large" style={{ width: '100%' }}>
              <Code  />
              <div style={{ display: 'flex', alignItems: 'center' }}>
                <div style={{ display: 'flex', flexDirection: 'column', alignItems: 'center', width: '40%' }}>
                  <Pass />
                  <Time />
                  <Times />
                  <Type />
                </div>
                <div style={{ marginLeft: '50px', display: 'flex', justifyContent: 'center' }}>
                  <Space size="large">
                    <Submit />
                    <Up />
                    <Link />
                  </Space>
                </div>
              </div>
            </Space>):(// download
                <Space size="large" style={{ width: '100%' }}>
                    <Download/>
                </Space>
            )
        }       
        </div>
      </Content>

    </Layout>
  );
}
