import React, { useState, useEffect, useRef } from 'react';
import { Input } from 'antd';
import hljs from 'highlight.js/lib/core';
import javascript from 'highlight.js/lib/languages/javascript';
import 'highlight.js/styles/atom-one-dark.css';

hljs.registerLanguage('javascript', javascript);



const Code2 = ({value}) => {
  const codeRef = useRef(null);

  

  useEffect(() => {
    hljs.highlightAll();
  }, [{value}]);

  return (
    <>    
      <pre ref={codeRef}>
        <code  className="hljs javascript" style={{ width: '80%', height: '200px' }}>
          {value}
        </code>
      </pre>
    </>
  );
};

export default Code2;
