import React, { useState } from 'react';
import { Button, Space, Input } from 'antd';
import {getText} from '../api/api';
import Code2 from './showCode';
import Pass from './password';
import {pass} from './password';

const Download = () => {
  const [url, setUrl] = useState('');
  const [text, setText] = useState('');
  const [state_, setState_] = useState(1);

  const handleUrl = (e) => {
    setUrl(e.target.value);
  };

  const handleClick = () => {
    getText(url, pass).then((response) => {
      if (response != null) {
        if (response.Code === 200) {
          setText(response.Data.Content);
        } else {
          if (response.Code === 403) {
            setText(response.Msg);
            setState_(2); // to auth
          } else {
            setText(response.Msg);
            setState_(3); // 过期
          }
        }
      }
    });
  };

  const handleReturn=()=>{
    setState_(1);
    setText("");
  }

  return (
    <div>
      {state_ === 1 ? (
        <div>
          <Input
            placeholder="Enter URL"
            style={{ width: '35%', height: '20px', marginBottom: '10px' }}
            onChange={handleUrl}
            onPressEnter={handleClick}
          />
          <Pass />          
          <Code2 value={text} />
          <Space wrap>
            <Button type="primary" onClick={handleClick}>
              Download
            </Button>
          </Space>
        </div>
      ) : state_ === 2 ? (
        <div>
          <p>Authenticating...</p>
        </div>
      ) : (
        <div>
          <p>{text}</p>
          <Button type="primary" onClick={handleReturn}>
              Return 
          </Button>
        </div>
      )}
    </div>
  );
};

export default Download;
