package model

import (
	"time"
    "math/rand"

	"github.com/sirupsen/logrus"
	"github.com/spf13/viper"
	"gorm.io/driver/mysql"
	"gorm.io/gorm"
)

var DB *gorm.DB
var id1 uint = 0

func Init() {
	connectDatabase()
	var err error
	// insert auto-table
	err = DB.AutoMigrate(&content{})
	if err != nil {
		logrus.Fatal(err)
	}
	err = DB.AutoMigrate(&Url{},&Users{})
	if err != nil {
		logrus.Fatal(err)
	}
}

func connectDatabase() {
	// config
	viper.SetConfigName("config")
	viper.SetConfigType("yaml")
	viper.AddConfigPath("./")
	err := viper.ReadInConfig()
	if err != nil {
		logrus.Panic(err)
	}
	// connect to database
	logInfo := viper.GetStringMapString("mysql")
	sqlInfo := logInfo["user"] + ":" + logInfo["password"] +
		"@(localhost)/" + logInfo["database"] + "?charset=utf8mb4&parseTime=True&loc=Local"
	DB, err = gorm.Open(mysql.Open(sqlInfo), &gorm.Config{})
	if err != nil {
		logrus.Panic(err)
	}
}

// Backcheck content through link
//通过链接反查内容
func findlink(_url string) string {
	var p content
	err := DB.First(&p, "Url = ?", _url)
	if err != nil {
		logrus.Error(err)
	}
	return p.Route
}

// save text information
//保存文本和文件信息
func savetext(_Route string, _Time uint, _Passwd string,_Time1 time.Time,_url string) {
	id1++
	p := content{
		ID :      id1,
		Route:    _Route,
		Passwd:     _Passwd,
		Date:    time.Now(),
		Time1:   _Time1,
		Time2:   0,
        Url: _url,
	}
	DB.Create(&p)
}

// Check whether the number of visits exceeds the threshold and the time limit
//检查是否超过总访问次数和截止时间
func checkt(_Route string) {
	var p content
	err := DB.First(&p, "Route = ?",_Route)
	if err != nil {
		logrus.Error(err)
	}
	t := time.Now()
	p.Time2++
	if p.Time2 > p.Time||t.After(p.Time1) {
		DB.Delete(&p)
	}
}

//查找sessionid和url是否关联
func find(sid string,_url string) bool {
	var url1 = new(Url)
	err := DB.Preload("User1").Where("Url=?",_url).Find(&url1)
	if err != nil {
		return true
	}
	return false
}

var letters = []rune("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")

//随机生成字符串
func randStr(n int) string {
    b := make([]rune, n)
    for i := range b {
        b[i] = letters[rand.Intn(len(letters))]
    }
    return string(b)
}

//新建用户
func createuser(_User Users) {
      _User.SessionId=randStr(8)
	  DB.Create(&_User)
}

//新建链接
func createlink(sid string , _passwd string , _url string) bool {
	var p content
	DB.First(&p, "Url = ?", _url)
	if p.Passwd == _passwd {
		 var p1 Users
		 var p2 Url
		 DB.First(&p1,"SessionId = ?",sid)
		 DB.First(&p2,"Url = ?",_url)
		 DB.Model(&p2).Association("User1").Append(&p1)
         return true
	}
	return false
}