package response

import (
	"net/http"

	"github.com/labstack/echo/v4"
)

type Response struct {
	Code int         `json:"Code"`
	Msg  string      `json:"Msg"`
	Data interface{} `json:"Data"`
}

func SendResponse(c echo.Context, code int, msg string, data ...interface{}) error {
	return c.JSON(http.StatusOK, Response{
		Code: code,
		Msg:  msg,
		Data: data,
	})
}

// 返回err
func SendResponse4(c echo.Context, err error) error {
	return c.JSON(http.StatusBadRequest, err.Error())
}
