package controller

import (
	"backend/app/response"
	"net"
	"net/http"
	"time"
	"github.com/labstack/echo/v4"
	"github.com/sirupsen/logrus"
	"fmt"
	"io"
)

type File struct {
	FileName   string `json:"fileName"`
	FileType   string `json:"fileType"`
	Expiration int    `json:"expiration"`
	User       string `json:"user"`
	Passwd     string `json:"passwd"`
	Url        string `json:"url"`
	Time 	   time.Time `json:"time"` // 用户指定的时间期限
	//Expiry     time.Time `json:"expiry"` // 有效期
	//Content string `json:"content"`
}


type Text struct {
	text string `json:"text"`
}

func Ping(c echo.Context) error {
	// just a demo
	return response.SendResponse(c, http.StatusOK, "", "pong!")
}



// 接收浏览器发来的文件，把文件储存在.\files\目录下
// 成功则返回上传成功，否则报错
// sessionId不直接绑定，通过cookie传
func RecvFile(c echo.Context) error {
	file, err := c.FormFile("file")
	if err != nil {
		logrus.Println(err)
		return err
	}
	// 打开用户上传的文件
	src, err := file.Open()
	if err != nil {
		logrus.Println(err)
		return err
	}
	defer src.Close()

	
	info := new(File)
	if err = c.Bind(info); err != nil {
		logrus.Println(err)
		return err
	}
	// 创建目标文件，就是我们打算把用户上传的文件保存到什么地方
	// file.Filename 参数指的是我们以用户上传的文件名，作为目标文件名，也就是服务端保存的文件名跟用户上传的文件名一样
	dst,filePath:=dstCreate(info,file.Filename)
	defer dst.Close()
	// 获取文件大小
	fi, err := dst.Stat()
	if err != nil{
		logrus.Println(err)
		return err
	}

	// 大小比较
	if fi.Size() > 8*1024*10224 {
		return c.HTML(http.StatusOK, "<p>文件上传失败: 文件大小超过8MB</p>")
	}
	if err != nil {
		fmt.Println(err)
		return err
	}

	// 这里将用户上传的文件复制到服务端的目标文件
	if _, err = io.Copy(dst, src); err != nil {
		logrus.Println(err)
		return err
	}
	
	// 更新数据库
	sid,url:=DBupdate(c,filePath,info)
	cookie := new(http.Cookie)
	SetCookie(c,cookie,sid,info.Expiration,info.Time)
	return response.SendResponse2(c, http.StatusOK,*cookie, GetFileContentType(info.FileType), fmt.Sprintf("文件上传成功： %s", file.Filename),url)
}

/*
 * 输入：前端提供的文件链接，
 * 返回：一个可供URL访问的链接（string）
 * cookie.Value 传sessionId
*/
func SendFile(c echo.Context) error {
	info := new(File)
	if err := c.Bind(info); err != nil {
		logrus.Println(err)
		return err
	}

	cookie,_:=c.Cookie("User")
	if cookie==nil{
		c.HTML(http.StatusBadRequest,"没有cookie")
	}

	// 鉴权
	if !Autheticate(cookie,info.Url,info.Passwd) {
		return response.SendResponse(c, http.StatusBadRequest, "msg", "", "密码错误")
	}

	info.FileType=TypeComplement(info.FileType) // 格式化后缀，仿止出错
	filePath := "./files/" + info.FileType + "/" + info.FileName  + info.FileType
	data := readFile(filePath)
	c.JSON(http.StatusOK, info)
	return response.SendResponse3(c, http.StatusOK,*cookie, GetFileContentType(info.FileType), data)
}



func RecvText(c echo.Context) error {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
	text := new(Text)
	if err := c.Bind(text); err != nil {
		fmt.Println(err)
		return err
	}
	//return text.text
	return nil
}

func SendText(conn net.Conn, text Text) error {
	buf := []byte(text.text)
	_, err := conn.Write(buf[:])
	if err != nil {
		fmt.Println(err)
		return err
	}
	return nil
}
