package controller

import (
	"backend/model"
	"net/http"
	"time"
	"fmt"
	"math/rand"
	"os"
	"github.com/labstack/echo/v4"
	"github.com/sirupsen/logrus"
)

// 如果没有对应文件夹就建立
func catalogBuild(fileType string) error {
	err := os.Mkdir("pastebin/backend/files/"+fileType, 0666)
	if err != nil {
		return err
	}
	return nil
}

var letters = []rune("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")

func IdGen(n int) string {
	b := make([]rune, n)
	rand.Seed(time.Now().UnixNano())
	//for i:=0;i<n;i++{
	for i := range b {
		b[i] = letters[rand.Intn(len(letters))]
	}
	return string(b)
}

/*
 * 新建一个sid和url的关联，并返回一个bool表示成功与否
 * 若无sessionId，生成一个八位sid并返回
 */
func newAuthenticate(sid string, url string, passwd string) (rsid string, b bool) {
	if sid == "" {
		rsid = IdGen(8)
	} else {
		rsid = sid
	}
	b = model.Createlink(rsid, passwd, url)
	return rsid, b
}

/*
 * 判断用户有无权限访问
 * sid 用cookie 储存传输，如果新生成sid，则保存至cookie
 */
func Autheticate(cookie *http.Cookie,url string,passwd string) bool {
	sid:=cookie.Value
	if model.Find(sid, url) {
		return true
	} else {
		if passwd != "" {
			var b bool
			sid, b = newAuthenticate(sid, url, passwd)
			cookie.Value=sid
			return b
		} else {
			return false
		}
	}
}

/*
 * 通过文件扩展名获取ContentType
 */
func GetFileContentType(fileType string) string {
	var StrRet string = ""
	switch fileType {
	case ".txt":
		StrRet = "text/plain"
	case ".csv":
		StrRet = "text/csv"
	case ".tex":
		StrRet = "application/x-tex"
	case ".md":
		StrRet = "text/x-markdown"
	}
	return StrRet
}


// 设置cookie name sid, value link
func SetCookie(c echo.Context,cookie *http.Cookie, sid string,maxAge int,time_ time.Time)  {
	cookie.Name = "User" // 标识为user
	//cookie.Value = string(uuid)  // 通过uuid和数据库，确定user是谁
	cookie.Value = sid
	cookie.Path = "/"
	// cookie有效期为3600秒
	if maxAge==0 {
		if time_.IsZero() {
			cookie.MaxAge = 3600
		} else {
			cookie.MaxAge=int(time.Until(time_).Seconds())
			if cookie.MaxAge<=0 {
				cookie.MaxAge = 3600
			}
		}
	} else {
		cookie.MaxAge = maxAge
	}
	// 设置cookie
	c.SetCookie(cookie)
}


func dstCreate(info *File,fileName string) (dst *os.File,filePath string){
	info.FileType=TypeComplement(info.FileType)
	filePath = "./files/" + info.FileType + "/" + fileName
	dst, err := os.Create(filePath)
	if err != nil {
		// 是否目录不完整引起的问题
		if !os.IsExist(err) {
			if catalogBuild(info.FileType) != nil {
				logrus.Println(err)
				return nil,""
			}
			dst, err = os.Create(filePath)
			if err != nil {
				logrus.Println(err)
				return nil,""
			}
		}
	}
	return dst,filePath
}

func DBupdate(c echo.Context,filePath string,info *File)(string,string){
	url:="http://pastebin/"+IdGen(8)
	cookie,_:=c.Cookie("User")
	var sid string
	if cookie==nil{
		sid=""
	}else{
		sid=cookie.Value
	}
	sid,_=newAuthenticate(sid,url,info.Url)
	model.Createlink(sid,info.Passwd,url)
	model.Savetext(filePath,30,info.Passwd,info.Time,url)
	return sid,url
}


func readFile(filePath string) string {
	src, err := os.Open(filePath)
	if err != nil {
		fmt.Println(err)
	}
	fi, err := src.Stat()
	if err != nil {
		fmt.Println(err)
	}

	defer func() {
		src.Close()
	}()

	data := make([]byte, fi.Size())
	_, err = src.Read(data)
	if err != nil {
		fmt.Println(err)
	}
	// 信息隐去
	//c.JSON(http.StatusOK, info)

	return string(data)
}



// 格式化后缀，仿止出错
func TypeComplement(typ string) string{
	// 类型判断
	if typ == "" {
		typ = ".txt"
	}else if typ[0] != '.'{
		typ="."+typ
	}
	return typ
}