// JavaScript source code
import React from 'react';
import { UploadOutlined } from '@ant-design/icons';
import { Button, message, Upload } from 'antd';

export const fileContent = {
    content: ''
  };
  

const props = {
    name: 'file',
    action: 'https://www.mocky.io/v2/5cc8019d300000980a055e76',
    headers: {
        authorization: 'authorization-text',
    },
    onChange(info) {
        if (info.file.status !== 'uploading') {
            console.log(info.file, info.fileList);
        }
        if (info.file.status === 'done') {
            message.success(`${info.file.name} file uploaded successfully`);
            const file = info.file.originFileObj; // 获取上传文件的 File 对象
            const reader = new FileReader();
            reader.readAsText(file); // 以文本格式读取上传文件
            reader.onload = function () {
              fileContent.content = reader.result; // 将读取结果保存到 fileContent 对象的 content 属性中
              console.log(fileContent.content); // 打印读取结果
            };
          } else if (info.file.status === 'error') {
            message.error(`${info.file.name} file upload failed.`);
            fileContent.content = ''; // 上传失败时将 content 属性置为空字符串
          }
          
    },
};
const Up = () => (
    <Upload {...props}>
        <Button icon={<UploadOutlined />}>Click to Upload</Button>
    </Upload>
);
export default Up;