package response

import (
	"net/http"

	"github.com/labstack/echo/v4"
)

type Response struct {
	Code int         `json:"code"`
	Msg  string      `json:"msg"`
	Type string      `json:"type"`
	Data interface{} `json:"data"`
}

type Response2 struct {
	Code int         `json:"code"`
	Type string      `json:"type"`
	Url  string      `json:"url"`
	Data interface{} `json:"data"`
}

func SendResponse(c echo.Context, code int, msg string, data ...interface{}) error {
	return c.JSON(http.StatusOK, Response{
		Code: code,
		Msg:  msg,
		Data: data,
	})
}

func SendResponse2(c echo.Context, code int, typ string, url string, data ...interface{}) error {
	return c.JSON(http.StatusOK, Response2{
		Code: code,
		Type: typ,
		Url:  url,
		Data: data,
	})
}

func SendResponse3(c echo.Context, code int, typ string, data ...interface{}) error {
	return c.JSON(http.StatusOK, Response2{
		Code: code,
		Type: typ,
		Data: data,
	})
}

// 返回err
func SendResponse4(c echo.Context, err error) error {
	return c.JSON(http.StatusBadRequest, err.Error())
}
