package app

import (
	"backend/utils"
	//"net/http"
	"github.com/labstack/echo/v4"
	"github.com/sirupsen/logrus"
	"github.com/spf13/viper"
)

var e *echo.Echo

func InitWebFramework() {
	e = echo.New()
	e.HideBanner = true
	addRoutes()
	e.Validator = &utils.CustomValidator{}

	logrus.Info("echo framework initialized")
}

func StartServer() {
	e.Logger.Fatal(e.Start(getSetting("testurl"))) // 启动服务，注意默认端口80不能省略
	//e.Logger.Fatal(e.Start("127.0.0.1:80")) // 启动服务，注意默认端口80不能省略
	//e.Logger.Fatal(e.Start("http://xlab.zju.edu.cn/test/pastebin/group-1"))  // 启动服务，注意默认端口80不能省略,需要域名解析，config
}

/*
 * 初始化logger设置
 */
func InitLogger() {
	//自定义日志格式
	logrus.SetFormatter(&logrus.TextFormatter{
		ForceQuote:      true,                  //键值对加引号
		TimestampFormat: "2006-01-02 15:04:05", //时间格式
		FullTimestamp:   true,
	})
	logrus.SetReportCaller(true)
}

func getSetting(key string) (value string) {
	// config
	viper.SetConfigName("config")
	viper.SetConfigType("yaml")
	viper.AddConfigPath("./")
	err := viper.ReadInConfig()
	if err != nil {
		logrus.Panic(err)
	}
	// connect to database
	logInfo := viper.GetStringMapString("setting")
	return logInfo[key]
}
