package controller

import (
	"backend/app/response"
	"backend/model"
	"fmt"
	"net/http"
	"time"

	"github.com/labstack/echo/v4"
	"github.com/sirupsen/logrus"
)

type File struct {
	Content    string    `json:"content" form:"content" query:"content"`
	FileName   string    `json:"fileName" form:"fileName" query:"fileName"`
	FileType   string    `json:"fileType" form:"fileType" query:"fileType"`
	Expiration int       `json:"expiration" form:"expiration" query:"expiration"`
	User       string    `json:"user" form:"user" query:"user"`
	Passwd     string    `json:"passwd" form:"passwd" query:"passwd"`
	Url        string    `json:"url" form:"url" query:"url"`
	Time       time.Time `json:"time" form:"time" query:"time"`                // 用户指定的时间期限
	MaxAccess  uint      `json:"maxaccess" form:"maxaccess" query:"maxaccess"` // 文件最大可访问次数
	//Expiry     time.Time `json:"expiry"` // 有效期
	//Content string `json:"content"`
}

func Ping(c echo.Context) error {
	// just test
	return response.SendResponse(c, http.StatusOK, "", "pong!")
}

// 接收浏览器发来的文件，把文件储存在.\files\目录下
// 成功则返回上传成功，否则报错
// sessionId不直接绑定，通过cookie传
func RecvFile(c echo.Context) error {
	info := new(File)
	if err := c.Bind(info); err != nil {
		return err
	}
	info.Time = timeAssign(info.Time) // 默认时间

	if overflow(info, 8*1024*1024) {
		return response.SendResponse(c, http.StatusForbidden, "error:文件上传失败: 文件大小超过8MB.", "")
	}

	// 更新数据库
	_, url := DBupdate(c, info) // 不分配uid
	return response.SendResponse2(c, http.StatusOK, fmt.Sprintf("文件上传成功： %s", info.FileName), info.FileName, GetFileContentType(info.FileType), url)
}

/*
 * 输入：前端提供的文件链接，
 * 返回：一个可供URL访问的链接（string）
 * cookie.Value 传sessionId
 */
func SendFile(c echo.Context) error {
	info := new(File)
	if err := c.Bind(info); err != nil {
		logrus.Println(err)
		return err
	}
	info.Time = timeAssign(info.Time) // 默认时间为当前半小时后

	cookie, _ := c.Cookie("User")
	cookieMsg := ""
	if cookie == nil {
		cookieMsg = "没有cookie,已分配.\n"
		cookie = new(http.Cookie)
		SetCookie(c, cookie, IdGen(8), 1800, time.Time{})
	}

	// 鉴权
	stat := Autheticate(cookie, info.Url, info.Passwd, info.Time) // 包含创建链接Createlink
	// response
	switch stat {
	case 0:
		return response.SendResponse(c, http.StatusForbidden, cookieMsg+"error:密码错误", "") //403
		//return c.JSON(http.StatusForbidden, "error:密码错误") // 403
	case 1: // 鉴权通过
		data := model.Find1(info.Url, "content")                                                                  // 文件内容
		typ := model.Find1(info.Url, "fileType")                                                                  // 文件类型
		name := model.Find1(info.Url, "fileName")                                                                 // 文件名
		return response.SendResponse3(c, http.StatusOK, cookieMsg+"success", name, GetFileContentType(typ), data) // 返回数据
	case 2:
		return response.SendResponse(c, http.StatusGone, cookieMsg+"error:内容过期", "") //410
		//return c.HTML(http.StatusGone, "error:内容过期")
	case 3:
		return response.SendResponse(c, http.StatusUnauthorized, cookieMsg+"error:内容过期", "") //401
		//return c.HTML(http.StatusUnauthorized, "请进行身份验证")
	}
	return nil
}

// 申请一个包含uid的cookie
func AskUid(c echo.Context) error {
	nsid := IdGen(8)
	info := new(File)
	cookie := new(http.Cookie)
	err := SetCookie(c, cookie, nsid, info.Expiration, info.Time)
	if err != nil {
		return err
	} else {
		return c.HTML(http.StatusOK, "success")
	}

}
